/*
 	v0.1 - [28.09.2011] First release
	v0.1a - [29.09.2011] Fixed little bug in cs 1.6
	v0.1b - [12.10.2011] Fixed blood stream
	
	IDEA TAKEN FROM: "Ultimate Gore" - "JTP10181"
	
	http://aghl.ru/forum/ - Russian Half-Life and Adrenaline Gamer Community
*/

#include <amxmodx>
#include <fakemeta>
#include <xs>

#define PLUGIN 	"hl_ultimate_gore_upd"
#define VERSION "0.1b"
#define AUTHOR 	"Turanga_Leela"

//#define Half_Life // remove comment for Half-Life

#define BLOOD_COLOR_RED		247
#define BLOOD_STREAM_RED	70

enum _:BLOOD_SPR
{
	BLOOD_DROP,
	BLOOD_SPRAY
}

enum _:GIB_MDL
{
	HEAD,
	LEG,
	BONE,
	LUNG,
	GIB
}

new g_blood[BLOOD_SPR],
g_model[GIB_MDL]

public plugin_precache()
{
	g_blood[BLOOD_DROP] = precache_model("sprites/blood.spr")
	g_blood[BLOOD_SPRAY] = precache_model("sprites/bloodspray.spr")
	
	g_model[HEAD] = precache_model("models/gib_skull.mdl")
	g_model[LEG] = precache_model("models/gib_legbone.mdl")
	g_model[BONE] = precache_model("models/gib_b_bone.mdl")
	g_model[LUNG] = precache_model("models/gib_lung.mdl")
	g_model[GIB] = precache_model("models/gib_b_gib.mdl")
}

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_event("Damage", "on_damage", "b", "2>0")
#if !defined Half_Life	
	register_message(122, "cl_corpse")
#endif
}

#if !defined Half_Life
public cl_corpse()
{
	return PLUGIN_HANDLED
}
#endif

public on_damage(id)
{
	static Float:origin_id[3], Float:origin_attacker[3], hitBox, weapon, attacker
	
	attacker = get_user_attacker(id, weapon, hitBox)
	
	pev(id, pev_origin, origin_id)
	
	if(hitBox == HIT_HEAD)
		origin_id[2] += 17 
	
	if(is_user_alive(id))
		blood(origin_id, 5)	
	
	else if(!is_user_alive(id))
	{
		if(hitBox == HIT_HEAD)
		{
			new num = random(2), damage = read_data(2) * 2
			
			if(damage < 125) damage = 125
			else if(damage > 425) damage = 425
			
			if(num)
			{
				set_pev(id, pev_effects, EF_NODRAW)
				gibs(origin_id, damage)		
			}

			else if(!num)
			{
				pev(attacker, pev_origin, origin_attacker)
				xs_vec_sub(origin_id, origin_attacker, origin_attacker)
				blood_stream(origin_id, origin_attacker, damage)
			}
		}

		else
			blood(origin_id, 15)	
	}
}

blood(Float:origin[], size)
{
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_BLOODSPRITE)
	
	engfunc(EngFunc_WriteCoord, origin[0])
	engfunc(EngFunc_WriteCoord, origin[1])
	engfunc(EngFunc_WriteCoord, origin[2])
	
	write_short(g_blood[BLOOD_SPRAY])
	write_short(g_blood[BLOOD_DROP])
	write_byte(BLOOD_COLOR_RED)
	write_byte(size)
	message_end()
}

blood_stream(Float:origin[], Float:velocity_vec[], damage)
{
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte(TE_BLOODSTREAM)
	
	engfunc(EngFunc_WriteCoord, origin[0])
	engfunc(EngFunc_WriteCoord, origin[1])
	engfunc(EngFunc_WriteCoord, origin[2])
	
	engfunc(EngFunc_WriteCoord, velocity_vec[0])
	engfunc(EngFunc_WriteCoord, velocity_vec[1])
	write_coord(damage)
	
	write_byte(BLOOD_STREAM_RED)
	write_byte(damage)
	message_end()
}

gibs(Float:origin[], damage)
{
	for(new i; i < sizeof g_model; i++)
	{
		message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
		write_byte(TE_MODEL)
	
		engfunc(EngFunc_WriteCoord, origin[0])
		engfunc(EngFunc_WriteCoord, origin[1])
		engfunc(EngFunc_WriteCoord, origin[2])
	
		write_coord(random(damage))
		write_coord(random(damage))
		write_coord(random(damage))
		
		write_angle(random(361))
		write_short(g_model[i])
		write_byte(1)
		write_byte(125)
		message_end()
	}		
}