/* VIPSystemMysql v1.4 */

#include <amxmodx>
#include <hamsandwich>
#include <sqlx>

#define VIP_STEAM 	(1<<0)
#define VIP_IP 		(1<<1)
#define VIP_NAME 	(1<<2)

new Array:vipAuthArray;
new Array:vipPasswordArray;
new Array:vipAccessArray;
new Array:vipFlagsArray;
new vipsNumber = 0;

new cvarPasswordField, cvarSqlHost, cvarSqlUser, cvarSqlPass, cvarSqlDb, cvarDbTable;

new forwardVipConnect, result;

new bool:vip[33], vipFlags[33];

new letter[26] = {'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
new maxPlayers;
new currentDate[12];

public plugin_init() 
{
	register_plugin("VIPSystem", "1.4", "ZETA [M|E|N]");
	
	register_dictionary("VIPSystem.txt");
	
	cvarPasswordField = register_cvar("vs_password_field", "_pw");
	cvarSqlHost = register_cvar("vs_sql_host", "localhost");
	cvarSqlUser = register_cvar("vs_sql_user", "root");
	cvarSqlPass = register_cvar("vs_sql_pass", "");
	cvarSqlDb = register_cvar("vs_sql_db", "VIPSystem");
	cvarDbTable = register_cvar("vs_db_table", "vips");
	
	forwardVipConnect = CreateMultiForward("VSVipConnect", ET_CONTINUE, FP_CELL);
	maxPlayers = get_maxplayers();
	
	get_time("%Y-%m-%d", currentDate, charsmax(currentDate));
	
	new configsDir[64];
	get_localinfo("amxx_configsdir", configsDir, charsmax(configsDir));
	server_cmd("exec %s/vips.cfg", configsDir);
	
	LoadVipList();
	
	register_concmd("vips_list", "ShowVipsList", ADMIN_ALL, "Show Vips List");
}

public plugin_precache()
{
	vipAuthArray = ArrayCreate(44, 1);
	vipPasswordArray = ArrayCreate(32, 1);
	vipAccessArray = ArrayCreate(1, 1);
	vipFlagsArray = ArrayCreate(1, 1);
}

FindFlag(const arr[], const ch)
{
	new size = strlen(arr);
	for (new i = 0; i < size; i++)
	{
		if (arr[i] == ch)
		{
			return true;
		}
	}
	
	return false;
}

ReadAccessFlags(const str[])
{
	new flagsBin = 0;
	for (new i = 0; i < 26; i++)
	{
		if (FindFlag(str, letter[i]))
		{
			flagsBin |= (1<<i);
		}
	}

	return flagsBin;
}

ReadAccountFlags(const str[])
{
	new accBin = 0;
	for (new i = 0; i < 3; i++)
	{
		if (FindFlag(str, letter[i]))
		{
			accBin |= (1<<i);
		}
	}
	
	return accBin;
}

LoadVip(const auth[], const pass[], const acc[], const flags[])
{
	ArrayPushString(vipAuthArray, auth);
	ArrayPushString(vipPasswordArray, pass);
	ArrayPushCell(vipAccessArray, ReadAccessFlags(acc));
	ArrayPushCell(vipFlagsArray, ReadAccountFlags(flags));
}

LoadVipList()
{
	new host[64], user[64], password[64], database[64], table[64];
	get_pcvar_string(cvarSqlHost, host, charsmax(host));
	get_pcvar_string(cvarSqlUser, user, charsmax(user));
	get_pcvar_string(cvarSqlPass, password, charsmax(password));
	get_pcvar_string(cvarSqlDb, database, charsmax(database));
	get_pcvar_string(cvarDbTable, table, charsmax(table));
	
	new error[512], errorCode, Handle: sqlConnection, Handle: sqlTuple;
	sqlTuple = SQL_MakeDbTuple(host, user, password, database);
	
	sqlConnection = SQL_Connect(sqlTuple, errorCode, error, charsmax(error));
	
	if(sqlConnection == Empty_Handle)
	{
		log_to_file("VIPSystem.txt", "LoadVipList(): %s", error);
		return;
	}
	
	new queryString[64], Handle: query;
	format(queryString, charsmax(queryString), "DELETE FROM `%s` WHERE `expired_date` = '%s'", table, currentDate);
	query = SQL_PrepareQuery(sqlConnection, queryString);
	SQL_Execute(query);
	
	format(queryString, charsmax(queryString), "SELECT `auth`,`password`,`access`,`flags` FROM `%s`", table);
	query = SQL_PrepareQuery(sqlConnection, queryString);
	SQL_Execute(query);
	
	new auth[44], pass[32], acc[26], flags[3];
	while(SQL_MoreResults(query)) 
	{
		SQL_ReadResult(query, 0, auth, charsmax(auth));
		SQL_ReadResult(query, 1, pass, charsmax(pass));
		SQL_ReadResult(query, 2, acc, charsmax(acc));
		SQL_ReadResult(query, 3, flags, charsmax(flags));
		
		LoadVip(auth, pass, acc, flags);
		++vipsNumber;
		
		SQL_NextRow(query);
	}
	
	SQL_FreeHandle(query);
	SQL_FreeHandle(sqlConnection);
	
	switch (vipsNumber)
	{
		case 0: server_print("[VIPSystem] %L", LANG_SERVER, "NO_VIPS");
		case 1: server_print("[VIPSystem] %L", LANG_SERVER, "LOADED_VIP");
		default: server_print("[VIPSystem] %L", LANG_SERVER, "LOADED_VIPS", vipsNumber);
	}
}

RemoveAccess(const id)
{
	vip[id] = false;
	vipFlags[id] = 0;
}

GetAccess(const id)
{
	new userName[32], passField[32], userPass[32], userAuth[32], userIp[44];
	get_user_info(id, "name", userName, charsmax(userName));
	get_pcvar_string(cvarPasswordField, passField, charsmax(passField));
	get_user_info(id, passField, userPass, charsmax(userPass));
	get_user_authid(id, userAuth, charsmax(userAuth));
	get_user_ip(id, userIp, charsmax(userIp), 1);
	
	RemoveAccess(id);
	
	new auth[44], pass[32], acc, flags;
	for (new i = 0; i < vipsNumber; i++)
	{
		ArrayGetString(vipAuthArray, i, auth, charsmax(auth));
		ArrayGetString(vipPasswordArray, i, pass, charsmax(pass));
		acc = ArrayGetCell(vipAccessArray, i);
		flags = ArrayGetCell(vipFlagsArray, i);
		
		if (((flags & VIP_STEAM) && equal(auth, userAuth)) || ((flags & VIP_IP) && equal(auth, userIp)))
		{
			vip[id] = true;
			vipFlags[id] = acc;
			break;
		}
		else if ((flags & VIP_NAME) && equal(auth, userName))
		{
			if (equal(pass, userPass))
			{
				vip[id] = true;
				vipFlags[id] = acc;
			}
			else
			{
				server_cmd("kick #%d ^"%L^"", get_user_userid(id), LANG_SERVER, "NO_ENTRY");
			}
			
			break;
		}
	}
}

ConnectGetAccess(const id)
{
	GetAccess(id);
	
	if (vip[id])
	{
		ExecuteForward(forwardVipConnect, result, id);
	}
}

// Events

public client_putinserver(id)
{
	ConnectGetAccess(id);
}

public client_disconnect(id)
{
	RemoveAccess(id);
}

public client_infochanged(id)
{
	new newname[32], oldname[32];
	get_user_name(id, oldname, charsmax(oldname));
	get_user_info(id, "name", newname, charsmax(newname));
	
	if (!equal(newname, oldname))
	{
		GetAccess(id);
	}
}

// Natives

public plugin_natives()
{	
	register_native("VSGetUserVip", "NativeGetUserVip", 1);
	register_native("VSGetVipFlag", "NativeGetVipFlag", 1);
	register_native("VSGetVipFlags", "NativeGetVipFlags", 1);
}

public NativeGetUserVip(id)
{
	if (!IsUser(id))
	{
		log_to_file("VIPSystem.txt", "NativeGetUserVip(id): %L", LANG_SERVER, "OUT_OF_RANGE", id);
		return false;
	}
	
	return vip[id];
}

public NativeGetVipFlag(id, flag)
{
	if (!IsUser(id))
	{
		log_to_file("VIPSystem.txt", "NativeGetVipFlag(id, flag): %L", LANG_SERVER, "OUT_OF_RANGE", id);
		return false;
	}
	
	if (!vip[id])
	{
		return false;
	}
	
	if (flag && !(vipFlags[id] & flag))
	{
		return false;
	}
	
	return true;
}

public NativeGetVipFlags(id)
{
	if (!IsUser(id))
	{
		log_to_file("VIPSystem.txt", "NativeGetVipFlags(id): %L", LANG_SERVER, "OUT_OF_RANGE", id);
		return 0;
	}
	
	return vipFlags[id];
}

// Commands

public ShowVipsList(id)
{
	if (id)
	{
		client_print(id, print_console, "Unknown command: vips_list");
		return PLUGIN_HANDLED;
	}
	
	new auth[44], pass[32], accBin, flagsBin, acc[26], flags[3];
	server_print("%L", LANG_SERVER, "VIPS_LIST");
	
	if (!vipsNumber)
	{
		server_print("%L", LANG_SERVER, "NO_VIPS");
		return PLUGIN_HANDLED;
	}
	
	for(new i = 0; i < vipsNumber; i++)
	{
		ArrayGetString(vipAuthArray, i, auth, charsmax(auth));
		ArrayGetString(vipPasswordArray, i, pass, charsmax(pass));
		accBin = ArrayGetCell(vipAccessArray, i);
		flagsBin = ArrayGetCell(vipFlagsArray, i);
		
		format(acc, charsmax(acc), "");
		for (new i = 0, len = 0; i < 26; i++)
		{
			if (accBin & (1<<i))
			{
				strcat(acc, letter[i], ++len);
			}
		}
		
		format(flags, charsmax(flags), "");
		for (new i = 0, len = 0; i < 3; i++)
		{
			if (flagsBin & (1<<i))
			{
				strcat(flags, letter[i], ++len);
			}
		}
		
		server_print("^"%s^" ^"%s^" ^"%s^" ^"%s^"", auth, pass, acc, flags);
	}
	
	return PLUGIN_HANDLED;
}

public IsUser(id)
{
	return (1 <= id <= maxPlayers);
}

public plugin_end()
{
	ArrayDestroy(vipAuthArray);
	ArrayDestroy(vipPasswordArray);
	ArrayDestroy(vipAccessArray);
	ArrayDestroy(vipFlagsArray);
}
