#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <sqlx>

#define PLUGIN "Web Chat"
#define VERSION "1.2.1"
#define AUTHOR "BaHeK"

new Handle:g_h_Sql, Handle:g_h_Sql_Connect;
new g_pCvarSQLHost;
new g_pCvarSQLUser;
new g_pCvarSQLPass;
new g_pCvarSQLDb;
new g_pCvar_ipfix;
new g_pCvar_sim;
new g_pCvar_reconnectmysql;
new ignore, rcmysql;
new bool:is_connected_mysql;
new host[64], user[64], pass[128], db[128], _hostip[128];

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	g_pCvarSQLHost = register_cvar( "amx_webchat_host", "localhost" );
	g_pCvarSQLUser = register_cvar( "amx_webchat_user", "root" );
	g_pCvarSQLPass = register_cvar( "amx_webchat_pass", "" );
	g_pCvarSQLDb = register_cvar( "amx_webchat_db", "" );
	g_pCvar_ipfix = register_cvar( "amx_webchat_ipfix", "" );
	g_pCvar_sim = register_cvar( "amx_webchat_ignore_sim", "0" );
	g_pCvar_reconnectmysql = register_cvar( "amx_webchat_reconnectmysql", "1" );
	
	register_clcmd("say", "websay");
	register_clcmd("say_team", "websay_team");
	
	set_task(0.3, "connect_data_base");
}

public websay(id)
{
	if(!is_user_connected(id)||is_user_bot(id)||is_user_hltv(id)) return;
	new name[33], steam[33], ip[33], hostip[33], team, alive, zapr[1024], message[192], msg[400], _hostip1[66], _name[66];
	get_user_name(id, name, 32);
	get_user_ip(id, ip, 32, 1);
	get_user_authid(id, steam, 32);
	if(equali(_hostip, ""))
		get_user_ip(0, hostip, 32)
	else
		formatex(hostip, 32, "%s", _hostip);
	read_args(message, 191);
	remove_quotes(message);
	if(ignore&&message[0]=='/') return;
	SQL_QuoteString(g_h_Sql_Connect, msg, 399, message)
	SQL_QuoteString(g_h_Sql_Connect, _hostip1, 65, hostip)
	SQL_QuoteString(g_h_Sql_Connect, _name, 65, name)
	if(!message[0])
		return
	if(is_user_alive(id))
		alive = 1;
	else
		alive = 0;
		
	if(cs_get_user_team(id) == CS_TEAM_T)
		team = 1;
	else if(cs_get_user_team(id) == CS_TEAM_CT)
		team = 2;
	else
		team = 0;
	
	formatex(zapr, 1023,"INSERT INTO `webchat` (`id`, `name`, `ip`, `steam`, `text`, `hostip`, `time`, `team`, `alive`, `teamchat`) VALUES (NULL, '%s', '%s', '%s', '%s', '%s', '%d', '%d', '%d', '0')", _name, ip, steam, msg, hostip, get_systime(), team, alive);
	if(is_connected_mysql) SQL_ThreadQuery(g_h_Sql, "say_sql", zapr);
}

public websay_team(id)
{
	if(!is_user_connected(id)||is_user_bot(id)||is_user_hltv(id)) return;
	new name[33], steam[33], ip[33], hostip[33], team, alive, zapr[1024], message[192], msg[400], _hostip1[66], _name[66];
	get_user_name(id, name, 32);
	get_user_ip(id, ip, 32, 1);
	get_user_authid(id, steam, 32);
	if(equali(_hostip, ""))
		get_user_ip(0, hostip, 32)
	else
		formatex(hostip, 32, "%s", _hostip)
	read_args(message, 191);
	remove_quotes(message);
	if(message[0]=='@') return;
	if(ignore&&message[0]=='/') return;
	SQL_QuoteString(g_h_Sql_Connect, msg, 399, message)
	SQL_QuoteString(g_h_Sql_Connect, _hostip1, 65, hostip)
	SQL_QuoteString(g_h_Sql_Connect, _name, 65, name)
	if(!message[0])
		return
	if(is_user_alive(id))
		alive = 1;
	else
		alive = 0;
	if(cs_get_user_team(id) == CS_TEAM_T)
		team = 1;
	else if(cs_get_user_team(id) == CS_TEAM_CT)
		team = 2;
	else
		team = 0;
		
	formatex(zapr, 1023,"INSERT INTO `webchat` (`id`, `name`, `ip`, `steam`, `text`, `hostip`, `time`, `team`, `alive`, `teamchat`) VALUES (NULL, '%s', '%s', '%s', '%s', '%s', '%d', '%d', '%d', '1')", _name, ip, steam, msg, _hostip1, get_systime(), team, alive);
	if(is_connected_mysql) SQL_ThreadQuery(g_h_Sql, "say_sql", zapr);
}

public say_sql(iFailState, Handle:hQuery, error[], err)
{
	if(iFailState != TQUERY_SUCCESS)
    	{
        	log_amx("sql error: %d (%s)", err, error)
        	if(rcmysql)
        	{
        		is_connected_mysql=false
        		set_task(5.0,"reconnect_to_mysql",68046,_,_,"b")
        		log_amx("Reconnect to database...")
        	}
        	else set_fail_state("stoped");
        	return
    	}
}

public plugin_cfg()
{
	new iCfgDir[ 32 ], iFile[ 192 ];
	
	get_configsdir( iCfgDir, charsmax( iCfgDir ) );
	formatex( iFile, charsmax( iFile ), "%s/webchat.cfg", iCfgDir );

	if( !file_exists( iFile ) )
	{
		log_amx( "Ошибка чтения файла webchat.cfg" );
		set_fail_state("stoped");
	}
	else
		server_cmd( "exec %s", iFile );
}

public reconnect_to_mysql()
{
    	SQL_FreeHandle(g_h_Sql);
    	new s_Error[128], i_Error;
	g_h_Sql = SQL_MakeDbTuple(host, user, pass, db);
	g_h_Sql_Connect = SQL_Connect(g_h_Sql, i_Error, s_Error, charsmax(s_Error));
	
	if(g_h_Sql_Connect == Empty_Handle)
	{
		log_amx("Can't connect to MySQL, error: %s^nReconnect to database...", s_Error);
	}
	else
	{
		remove_task(68046)
		log_amx("Connected")
		is_connected_mysql = true
		new _hostname[256], hostip[32], _hostip[32], _hostip1[64], _hostname1[512]
   		get_pcvar_string(g_pCvar_ipfix, _hostip, 127)
		get_cvar_string("hostname", _hostname, 255)
		if(equali(_hostip, ""))
			get_user_ip(0, hostip, 31)
		else
			formatex(hostip, 31, "%s", _hostip)
			
		SQL_QuoteString(g_h_Sql_Connect, _hostname1, 511, _hostname)
		SQL_QuoteString(g_h_Sql_Connect, _hostip1, 63, hostip)	
		SQL_QueryAndIgnore(g_h_Sql_Connect, "SET NAMES `utf8`")
		SQL_QueryAndIgnore(g_h_Sql_Connect, "CREATE TABLE IF NOT EXISTS `webchat` ( `id` int(8) NOT NULL AUTO_INCREMENT, `name` varchar(32) NOT NULL, `ip` varchar(32) NOT NULL, `steam` varchar(32) NOT NULL, `text` varchar(400) NOT NULL, `hostip` varchar(32) NOT NULL, `time` int(32) NOT NULL, `team` int(8) NOT NULL, `alive` int(8) NOT NULL, `teamchat` int(8) NOT NULL, PRIMARY KEY (`id`) ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;")
		SQL_QueryAndIgnore(g_h_Sql_Connect, "CREATE TABLE IF NOT EXISTS `host` ( `hostname` varchar(255) NOT NULL, `hostip` varchar(255) NOT NULL, PRIMARY KEY (`hostip`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;")
		SQL_QueryAndIgnore(g_h_Sql_Connect, "INSERT INTO `host` SET hostname='%s', hostip='%s' ON DUPLICATE KEY UPDATE hostname='%s'", _hostname1, _hostip1, _hostname1)
	}
}

public connect_data_base()
{
	new s_Error[128], i_Error;
	
	get_pcvar_string(g_pCvarSQLHost, host, 63);
	get_pcvar_string(g_pCvarSQLUser, user, 63);
	get_pcvar_string(g_pCvarSQLPass, pass, 127);
	get_pcvar_string(g_pCvarSQLDb, db, 127);
	ignore = get_pcvar_num(g_pCvar_sim);
	rcmysql = get_pcvar_num(g_pCvar_reconnectmysql);
	
	g_h_Sql = SQL_MakeDbTuple(host, user, pass, db);
	g_h_Sql_Connect = SQL_Connect(g_h_Sql, i_Error, s_Error, charsmax(s_Error));
	
	if(g_h_Sql_Connect == Empty_Handle)
	{
		if(rcmysql)
		{
			log_amx("Can't connect to MySQL, error: %s^nReconnect to database...", s_Error);
			set_task(5.0,"reconnect_to_mysql",68046,_,_,"b")
		}
		else
		{
			log_amx("Can't connect to MySQL, error: %s", s_Error);
			set_fail_state("stoped");
		}
	}
	else
	{
		is_connected_mysql = true;
		new _hostname[256], hostip[32], _hostip[32], _hostip1[64], _hostname1[512]
   		get_pcvar_string(g_pCvar_ipfix, _hostip, 127)
		get_cvar_string("hostname", _hostname, 255)
		if(equali(_hostip, ""))
			get_user_ip(0, hostip, 31)
		else
			formatex(hostip, 31, "%s", _hostip)
			
		SQL_QuoteString(g_h_Sql_Connect, _hostname1, 511, _hostname)
		SQL_QuoteString(g_h_Sql_Connect, _hostip1, 65, hostip)	
		SQL_QueryAndIgnore(g_h_Sql_Connect, "SET NAMES `utf8`")
		SQL_QueryAndIgnore(g_h_Sql_Connect, "CREATE TABLE IF NOT EXISTS `webchat` ( `id` int(8) NOT NULL AUTO_INCREMENT, `name` varchar(32) NOT NULL, `ip` varchar(32) NOT NULL, `steam` varchar(32) NOT NULL, `text` varchar(400) NOT NULL, `hostip` varchar(32) NOT NULL, `time` int(32) NOT NULL, `team` int(8) NOT NULL, `alive` int(8) NOT NULL, `teamchat` int(8) NOT NULL, PRIMARY KEY (`id`) ) ENGINE=MyISAM  DEFAULT CHARSET=utf8;")
		SQL_QueryAndIgnore(g_h_Sql_Connect, "CREATE TABLE IF NOT EXISTS `host` ( `hostname` varchar(255) NOT NULL, `hostip` varchar(255) NOT NULL, PRIMARY KEY (`hostip`) ) ENGINE=MyISAM DEFAULT CHARSET=utf8;")
		SQL_QueryAndIgnore(g_h_Sql_Connect, "INSERT INTO `host` SET hostname='%s', hostip='%s' ON DUPLICATE KEY UPDATE hostname='%s'", _hostname1, _hostip1, _hostname1)
	}
}

public plugin_end()
{
    	SQL_FreeHandle(g_h_Sql_Connect);
    	SQL_FreeHandle(g_h_Sql);
}