/* Plugin generated by AMXX-Studio */

#include <amxmodx>
#include <amxmisc>
#include <hamsandwich>
#include <xs> 
#include <engine> 
#include <WPMGPrintChatColor>
#include <next21_>

#define PLUGIN "next21_duels"
#define VERSION "0.5"
#define AUTHOR "Psycrow"

new bool:duel_ready[33][33] //      
new bool:duel_ready_one[33] //       (       )
new duel_frags[33][33] //    
new idd[33] //     id .

static sound_duel[] 				= "next21_duels/duel_challenge_accepted.wav"
static sound_win[]				= "next21_duels/win.wav"
static sound_lose[] 				= "next21_duels/lose.wav"
static duel_sprite 

new Float:g_fDelay[33]
new cvar_maxdistance 
new cvar_updatedelay

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_clcmd( "say /duel", "Check_Players" )
	register_clcmd( "say_team /duel", "Check_Players" )
	register_clcmd( "say /unduel", "Unduel" )
	register_clcmd( "say_team /unduel", "Unduel" )
	RegisterHam(Ham_Killed,"player","Duel")
	register_message(get_user_msgid("TeamInfo"),"TeamInfoCallback")
	
	register_cvar("cv_duels_frags","3") // -   
	register_cvar("cv_duels_reward","3000") //     . 0 -  
	register_cvar("cv_duels_losing","3000") //         . 0 -  
	register_cvar("cv_duels_maxmoney","16000") //       - ,  
	register_cvar("cv_duels_sounds","1") //   
	register_cvar("cv_duels_sprite","1") //   
	
	cvar_maxdistance = register_cvar("cv_duel_distance",  "2000") 
	cvar_updatedelay = register_cvar("cv_duel_updatedelay", "0.1") 
}

public plugin_precache()
{		
	precache_sound(sound_duel)
	precache_sound(sound_win)
	precache_sound(sound_lose)
	
	duel_sprite  = precache_model("sprites/next21_duels/duel.spr") 
}

public client_connect(id)
{
	new s_Players[32], i_Num, player
	get_players(s_Players, i_Num)
	for (new i; i < i_Num; i++)
	{ 
		player = s_Players[i]
		duel_ready_one[id] = false
		duel_ready[id][player] = false
		duel_ready[player][id] = false
		duel_frags[id][player] = 0
		duel_frags[player][id] = 0
	}
}

public client_disconnect(id)
{
	if(!duel_ready_one[id])
	return
	
	new s_Players[32], i_Num, player
	get_players(s_Players, i_Num)
	for (new i; i < i_Num; i++)
	{ 
		player = s_Players[i]
		if(duel_ready[id][player])
		{
			new player_name[33]
			get_user_name(id, player_name, charsmax(player_name))
			PrintChatColor(player, PRINT_COLOR_RED, "!g[Duels] !tИгрок !g%s !tвышел с сервера. Дуэль прервана.",player_name)
			duel_frags[player][id] = 0
			duel_ready[player][id] = false
			duel_ready_one[player] = false
			break
		}
	}
}

public Check_Players(id)
{
	if(duel_ready_one[id])
	{
		new d_Players[32], d_Num, d_player
		get_players(d_Players, d_Num)
		for (new i; i < d_Num; i++) 
		{ 
			d_player = d_Players[i]
			if(duel_ready[id][d_player])
			{
				new player_name[33]
				get_user_name(d_player, player_name, charsmax(player_name))
				PrintChatColor(id, PRINT_COLOR_RED, "!g[Duels] !tВы уже участвуете в дуэли с !g%s",player_name)
				PrintChatColor(id, PRINT_COLOR_RED, "!g[Duels] !tЧтобы прервать дуэль введите в чате !g/unduel")
				return
			}
		}
	}
    
	new Players_Menu = menu_create("\rКого вызвать на дуэль?", "menu_handler") //    
	new s_Players[32], i_Num, i_Player //    ,   , 
	new s_Name[32], s_Player[10] //    

	get_players(s_Players, i_Num)
	for (new i; i < i_Num; i++) { 
		i_Player = s_Players[i]
		idd[i_Player] = id
	
		get_user_name(i_Player, s_Name, charsmax(s_Name))
		num_to_str(i_Player, s_Player, charsmax(s_Player))

		if(i_Player == id || cs_get_user_team(i_Player) == cs_get_user_team(id) || duel_ready_one[i_Player] || cs_get_user_team(i_Player) == 3)
		format(s_Name,charsmax(s_Player),"\d%s", s_Name)
		
		menu_additem(Players_Menu, s_Name, s_Player, 0)
        
		}
	menu_setprop(Players_Menu, MPROP_EXITNAME, "\yВыход")
	menu_setprop(Players_Menu, MPROP_NEXTNAME, "\yВперед")
	menu_setprop(Players_Menu, MPROP_BACKNAME, "\yНазад")
	menu_display(id, Players_Menu, 0)
}
 
public menu_handler(id, menu, item)
{
	if (item == MENU_EXIT)
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}
 
	new s_Data[6], s_Name[64], i_Access, i_Callback
	menu_item_getinfo(menu, item, i_Access, s_Data, charsmax(s_Data), s_Name, charsmax(s_Name), i_Callback)
    
	new i_Player = str_to_num(s_Data)
    
	if(id == i_Player)
	{
		PrintChatColor(id, PRINT_COLOR_RED, "!g[Duels] !tНельзя вызывать на дуэль самого себя!")
		Check_Players(id)
		return PLUGIN_HANDLED
	}
   
	if(cs_get_user_team(id) == cs_get_user_team(i_Player))
	{
		PrintChatColor(id, PRINT_COLOR_RED, "!g[Duels] !tНельзя вызывать на дуэль товарища по команде!")
		Check_Players(id)
		return PLUGIN_HANDLED
	}
     
	if(duel_ready_one[i_Player])
	{
		PrintChatColor(id, PRINT_COLOR_RED, "!g[Duels] !tЭтот игрок уже участвует в другой дуэли!")
		Check_Players(id)
		return PLUGIN_HANDLED
	}
	
	if(cs_get_user_team(i_Player) == 3)
	{
		PrintChatColor(id, PRINT_COLOR_RED, "!g[Duels] !tНельзя вызывать на дуэль зрителя")
		Check_Players(id)
		return PLUGIN_HANDLED
	}
     

	new player_name[33], player_name_e[33]
	get_user_name(id, player_name, charsmax(player_name))
	get_user_name(i_Player, player_name_e, charsmax(player_name_e))
	
	PrintChatColor(i_Player, PRINT_COLOR_RED, "!g[Duels] !tИгрок !g%s вызвал вас на дуэль",player_name)
	PrintChatColor(id, PRINT_COLOR_RED, "!g[Duels] !tОжидание ответа от игрока !g%s!t...",player_name_e)
   
	new duel_Menu = menu_create("\rВас вызвали на дуэль", "menu_handler_duel")
    
	menu_additem(duel_Menu, "\wСогласиться на дуэль", "1", 0)
	menu_additem(duel_Menu, "\wОтказаться", "2", 0)
     
	menu_setprop(duel_Menu, MPROP_EXITNAME, "\yВыход")
	menu_setprop(duel_Menu, MPROP_NEXTNAME, "\yВперед")
	menu_setprop(duel_Menu, MPROP_BACKNAME, "\yНазад")
     
	menu_destroy(menu)
	menu_display(i_Player, duel_Menu, 0)
	return PLUGIN_HANDLED
} 
 
public menu_handler_duel(i_Player, menu, item)
{
	new id = idd[i_Player]
	if (item == MENU_EXIT)
	{
		new Player_name[33]
		get_user_name(i_Player, Player_name, 31) 
		PrintChatColor(i_Player, PRINT_COLOR_RED, "!g[Duels] !tВы отказались от дуэли")
		PrintChatColor(id, PRINT_COLOR_RED, "!g[Duels] !tИгрок !g%s !tотказался от дуэли",Player_name)
		menu_destroy(menu)
	}

	new d_Data[6], d_Name[64], d_Access, d_Callback

	menu_item_getinfo(menu, item, d_Access, d_Data, charsmax(d_Data), d_Name, charsmax(d_Name), d_Callback)

	new d_Key = str_to_num(d_Data)

	switch(d_Key)
	{
		case 1:
		{
			new Player_name_id[33], Player_name[33]
			get_user_name(id, Player_name_id, 31)
			get_user_name(i_Player, Player_name, 31)
			PrintChatColor(id, PRINT_COLOR_RED, "!g[Duels] !tИгрок !g%s !tсогласился на дуэль", Player_name)
			PrintChatColor(i_Player, PRINT_COLOR_RED, "!g[Duels] !tВы согласились на дуэль с игроком !g%s",Player_name_id)
			PrintChatColor(id, PRINT_COLOR_RED, "!g[Duels] !tЧтобы выйграть дуэль, убейте своего портивника !g%d !tраза",get_cvar_num("cv_duels_frags"))
			PrintChatColor(i_Player, PRINT_COLOR_RED, "!g[Duels] !tЧтобы выйграть дуэль, убейте своего портивника !g%d !tраза",get_cvar_num("cv_duels_frags"))
			duel_ready[id][i_Player] = true
			duel_ready[i_Player][id] = true
			duel_ready_one[id] = true
			duel_ready_one[i_Player] = true
			menu_destroy(menu)
			if(get_cvar_num("cv_duels_sounds"))
			{
				client_cmd(i_Player, "spk %s", sound_duel)
				client_cmd(id, "spk %s", sound_duel)
			}
		}
		case 2:
		{
			new Player_name[33]
			get_user_name(i_Player, Player_name, 31) 
			PrintChatColor(i_Player, PRINT_COLOR_RED, "!g[Duels] !tВы отказались от дуэли")
			PrintChatColor(id, PRINT_COLOR_RED, "!g[Duels] !tИгрок !g%s !tотказался от дуэли",Player_name)
			menu_destroy(menu)
		}
	}

	menu_destroy(menu)
	return PLUGIN_HANDLED
}

public Duel(victim, attacker){
	if(!duel_ready[victim][attacker] || !duel_ready[attacker][victim])
	return
	
	new Player_name_a[33], Player_name_v[33]
	get_user_name(victim, Player_name_v, 31)
	get_user_name(attacker, Player_name_a, 31)
	
	duel_frags[attacker][victim] += 1
	
	if(duel_frags[attacker][victim] == get_cvar_num("cv_duels_frags"))
	{
		PrintChatColor(0, PRINT_COLOR_RED, "!g[Duels] !tДуэль между !g%s !tи !g%s !tзавершена. Победитель !g%s, !tсчет !g%d!t-!g%d", Player_name_a, Player_name_v, Player_name_a, duel_frags[attacker][victim], duel_frags[victim][attacker])
		if(get_cvar_num("cv_duels_reward"))
		{
			new dl_maxmoney = get_cvar_num("cv_duels_maxmoney")
			new dl_upmoney = get_cvar_num("cv_duels_reward")
			if((cs_get_user_money(attacker)+dl_upmoney) > dl_maxmoney)
			{
				PrintChatColor(attacker, PRINT_COLOR_RED, "!g[Duels] !tЗа победу на дуэли вы получаете !g%d$",dl_maxmoney-cs_get_user_money(attacker))
				cs_set_user_money(attacker,dl_maxmoney)	
			}
			else
			{
				PrintChatColor(attacker, PRINT_COLOR_RED, "!g[Duels] !tЗа победу на дуэли вы получаете !g%d$",dl_upmoney)
				cs_set_user_money(attacker,cs_get_user_money(attacker)+dl_upmoney)
			}
		}
		if(get_cvar_num("cv_duels_losing"))
		{
			new dl_downmoney = get_cvar_num("cv_duels_losing")
			if(cs_get_user_money(victim) < dl_downmoney)
			{
				PrintChatColor(victim, PRINT_COLOR_RED, "!g[Duels] !tЗа проигрыш на дуэли вы теряете !g%d$",cs_get_user_money(victim))
				cs_set_user_money(victim,0)
				
			}
			else
			{
				PrintChatColor(victim, PRINT_COLOR_RED, "!g[Duels] !tЗа проигрыш на дуэли вы теряете !g%d$",dl_downmoney)
				cs_set_user_money(victim,cs_get_user_money(victim)-dl_downmoney)
			}
		}
		if(get_cvar_num("cv_duels_sounds"))
		{
			client_cmd(attacker, "spk %s", sound_win)
			client_cmd(victim, "spk %s", sound_lose)
		}
		duel_frags[attacker][victim] = 0
		duel_frags[victim][attacker] = 0
		duel_ready[attacker][victim] = false
		duel_ready[victim][attacker] = false
		duel_ready_one[victim] = false
		duel_ready_one[attacker] = false
		return
	}
		
	PrintChatColor(attacker, PRINT_COLOR_RED, "!g[Duels] !tТак держать. Вам осталось !g%d !tфрагов до победы на дуэли",get_cvar_num("cv_duels_frags") - duel_frags[attacker][victim])
	PrintChatColor(victim, PRINT_COLOR_RED, "!g[Duels] !tПротивнику осталось !g%d !tфрагов до победы на дуэли",get_cvar_num("cv_duels_frags") - duel_frags[attacker][victim])

}

public Unduel(id)
{
	if(!duel_ready_one[id])
	PrintChatColor(id, PRINT_COLOR_RED, "!g[Duels] !tВы не состоите в дуэли")
	else
	{
		new s_Players[32], i_Num, player
		get_players(s_Players, i_Num)
		for (new i; i < i_Num; i++)
		{ 
			player = s_Players[i]
			if(duel_ready[id][player] || duel_ready[player][id])
			{
				new player_name[33]
				get_user_name(id, player_name, charsmax(player_name))
				PrintChatColor(player, PRINT_COLOR_RED, "!g[Duels] !tИгрок !g%s !tпрервал дуэль.",player_name)
				PrintChatColor(id, PRINT_COLOR_RED, "!g[Duels] !tДуэль прервана.")
				duel_frags[player][id] = 0
				duel_frags[id][player] = 0
				duel_ready[player][id] = false
				duel_ready[id][player] = false
				duel_ready_one[player] = false
				duel_ready_one[id] = false
				break
			}
		}
		if(get_cvar_num("cv_duels_losing"))
		{
			new dl_downmoney = get_cvar_num("cv_duels_losing")
			if(cs_get_user_money(id) < dl_downmoney)
			{
				PrintChatColor(id, PRINT_COLOR_RED, "!g[Duels] !tЗа выход из дуэли вы теряете !g%d$",cs_get_user_money(id))
				cs_set_user_money(id,0)
				
			}
			else
			{
				PrintChatColor(id, PRINT_COLOR_RED, "!g[Duels] !tЗа выход из дуэли вы теряете !g%d$",dl_downmoney)
				cs_set_user_money(id,cs_get_user_money(id)-dl_downmoney)
			}
		}
	}
}

public TeamInfoCallback()
{
	new id = get_msg_arg_int(1)
	if(!duel_ready_one[id])
	return
			
	new s_Players[32], i_Num, player
	get_players(s_Players, i_Num)
	for (new i; i < i_Num; i++)
	{ 
		player = s_Players[i]
		if(duel_ready[id][player] && (cs_get_user_team(id) == cs_get_user_team(player) || cs_get_user_team(id) == 3))
		{
			new player_name[33]
			get_user_name(id, player_name, charsmax(player_name))
			PrintChatColor(player, PRINT_COLOR_RED, "!g[Duels] !tИгрок !g%s !tперешел в другую команду. Дуэль прервана.",player_name)
			PrintChatColor(id, PRINT_COLOR_RED, "!g[Duels] !tВы перешли в другую команду. Дуэль прервана.")
			duel_frags[player][id] = 0
			duel_frags[id][player] = 0
			duel_ready[player][id] = false
			duel_ready[id][player] = false
			duel_ready_one[player] = false
			duel_ready_one[id] = false
			break
		}
	}
}

public client_PreThink(id) 
{
	if(!get_cvar_num("cv_duels_sprite"))
	return PLUGIN_CONTINUE 
	
	if(!is_user_alive(id))
	return PLUGIN_CONTINUE 
	
	if(!duel_ready_one[id])
	return PLUGIN_CONTINUE 

	if((g_fDelay[id] + get_pcvar_float(cvar_updatedelay)) > get_gametime())
	return PLUGIN_CONTINUE 

	g_fDelay[id] = get_gametime()
   
	new Float:fMyOrigin[3] 
	entity_get_vector(id, EV_VEC_origin, fMyOrigin)

	static Players[32], iNum
	get_players(Players, iNum, "a")
	for(new i; i < iNum; i++)
		if(id != Players[i])
		{ 
			new target = Players[i]
         
			if(!duel_ready[id][target])
			continue 
			
			new Float:fTargetOrigin[3] 
			entity_get_vector(target, EV_VEC_origin, fTargetOrigin)
         
			if((get_distance_f(fMyOrigin, fTargetOrigin) > get_pcvar_num(cvar_maxdistance))
			|| !is_in_viewcone(id, fTargetOrigin))
			continue 
         
			new Float:fMiddle[3], Float:fHitPoint[3] 
			xs_vec_sub(fTargetOrigin, fMyOrigin, fMiddle) 
			trace_line(-1, fMyOrigin, fTargetOrigin, fHitPoint) 
         
			new Float:fWallOffset[3], Float:fDistanceToWall 
         
			fDistanceToWall = vector_distance(fMyOrigin, fHitPoint) - 10.0 
			normalize(fMiddle, fWallOffset, fDistanceToWall) 
     
			new Float:fSpriteOffset[3] 
			xs_vec_add(fWallOffset, fMyOrigin, fSpriteOffset) 
			new Float:fScale, Float:fDistanceToTarget = vector_distance(fMyOrigin, fTargetOrigin) 
			if(fDistanceToWall > 100.0) 
			fScale = 6.0 * (fDistanceToWall / fDistanceToTarget) 
			else 
			fScale = 1.5 
			te_sprite(id, fSpriteOffset, duel_sprite, floatround(fScale), 125) 
		} 
	return PLUGIN_CONTINUE 
} 

stock te_sprite(id, Float:origin[3], sprite, scale, brightness) 
{ 
	message_begin(MSG_ONE, SVC_TEMPENTITY, _, id) 
	write_byte(TE_SPRITE) 
	write_coord(floatround(origin[0])) 
	write_coord(floatround(origin[1])) 
	write_coord(floatround(origin[2]+40)) 
	write_short(sprite) 
	write_byte(scale)  
	write_byte(brightness) 
	message_end() 
} 

stock normalize(Float:fIn[3], Float:fOut[3], Float:fMul) 
{ 
	new Float:fLen = xs_vec_len(fIn) 
	xs_vec_copy(fIn, fOut) 

	fOut[0] /= fLen, fOut[1] /= fLen, fOut[2] /= fLen 
	fOut[0] *= fMul, fOut[1] *= fMul, fOut[2] *= fMul 
} 
