﻿/*==========================================================================================
 * 
 * (\ ----- Описание ----- /)
 * 
 * 1. Плагин заменяет ваше стандартное меню террориста. ( Аналог extra items из zp )
 * 2. Теперь вам не понадобится вписывать каждый режим самостоятельно.
 * 3. Чтобы добавить режим в меню террориста, нужно его зарегистрировать.
 * 4. Если у вас в режиме нет дхуда, в плагине присутствует квар "dm_dhudmessage"
 *  если квар включен - при выборе режима пишет "Террорист выбрал режим - 'Название с меню'"
 *
 * (\ ----- Версии ----- /)
 *  www.Cs-Serva.Ucoz.Net
 * 0.1 - Реализация.
 * 0.2 - Добавлен квар настройки дхуд сообщений.
 * 0.3 - Добавлен отсчёт в меню.
 * 
===========================================================================================*/

#include < amxmodx >
#include < hamsandwich >
#include < dhudmessage >

#define RegisterMenu(%1,%2) register_menucmd(register_menuid(%1), 1023, %2)
#define TimerMenu 15

enum _:_DataMode
{
	s_Name[ 64 ],
	iRounds
}

new 
Array:g_ModesArray,
g_iNumModes,
g_iPlayerPage[ 33 ],
g_iRoundMode[ ] = 0,
bool:g_bOpen,
bool:g_bModeIsUsed,
g_Fwd_SelectedMode,
g_Fwd_Return,
iCvarDhud;

new
bool:g_bIsUseTimer,
g_iCountdownTimer[ 33 ],
Float:g_fLastGameTime[ 33 ];

public plugin_init()
{
	register_plugin( "Deathrun_Modes", "0.2", "BlackSmoke" );
	
	register_event( "HLTV", "fw_RoundStart", "a", "1=0", "2=0" );
	
	RegisterMenu( "MenuModes", "ActionModesMenu" );
	
	RegisterHam( Ham_Spawn, "player", "fw_SpawnPlayer" );
	
	g_ModesArray = ArrayCreate( _DataMode );
	g_Fwd_SelectedMode = CreateMultiForward( "dm_selected_mode", ET_IGNORE, FP_CELL, FP_CELL )
	iCvarDhud = register_cvar( "dm_dhudmessage", "1" );
}

public fw_RoundStart()
{
	g_bOpen = false;
	g_bModeIsUsed = false;
	for( new i = 0; i < g_iNumModes; i++ )
	{
		if( g_iRoundMode[ i ] )
		{
			g_iRoundMode[ i ]--
		}
	}
}

public fw_SpawnPlayer( id )
{
	if( get_user_team( id ) == 1 && !g_bOpen )
	{
		g_bOpen = true;
		g_iCountdownTimer[ id ] = TimerMenu;
		g_bIsUseTimer = true;
		Show__ModesMenu( id, g_iPlayerPage[ id ] = 0 );
		g_fLastGameTime[ id ] = get_gametime();
	}
}

public Show__ModesMenu( id, iPage )
{
	if( iPage < 0 )
	{
		return PLUGIN_HANDLED;
	}
	
	new s_Menu[ 512 ], iLen, iKey, Data[ _DataMode ], iItem;
	new iStart = iPage * 8;
	new iEnd = iStart + 8;
	iKey |= (1 << 9)
	iLen = format( s_Menu[ iLen ], charsmax( s_Menu ) - iLen, "\yВы террорист \dВыберите режим^nУ вас осталось \r%d \dсек, чтобы подумать^n^n", g_iCountdownTimer[ id ] );
	if( iEnd > g_iNumModes )
	{
		iEnd = g_iNumModes;
	}
	for( new i = iStart; i < iEnd; i++ )
	{
		ArrayGetArray( g_ModesArray, i, Data );
		if( g_iRoundMode[ i ] )
		{
			iLen += format( s_Menu[ iLen ], charsmax( s_Menu ) - iLen, "\r%d. \d%s \r[\y%d\r]^n", ++iItem, Data[ s_Name ], g_iRoundMode[ i ] );
		}
		else
		{
			iKey |= (1 << iItem);
			iLen += format( s_Menu[ iLen ], charsmax( s_Menu ) - iLen, "\r%d. \w%s^n", ++iItem, Data[ s_Name ] );
		}
	}
	
	if( iEnd < g_iNumModes )
	{
		iKey |= (1 << 8);
		iLen += format( s_Menu[ iLen ], charsmax( s_Menu ) - iLen, "^n\r9. \wДалее^n\r0. \w%s", iPage ? "Назад" : "Выход" )
	}
	else
	{
		iLen += format( s_Menu[ iLen ], charsmax( s_Menu ) - iLen, "^n\r0. \w%s", iPage ? "Назад" : "Выход" );
	}
	
	return show_menu( id, iKey, s_Menu, -1, "MenuModes" );
}

public ActionModesMenu( id, iKey )
{
	new Data[ _DataMode ];
	switch( iKey )
	{
		case 8: Show__ModesMenu( id, ++g_iPlayerPage[ id ] )
		case 9: Show__ModesMenu( id, --g_iPlayerPage[ id ] )
		default:
		{
			new iMode = g_iPlayerPage[ id ] * 8 + iKey;
			if( g_iRoundMode[ iMode ] || g_bModeIsUsed )
				return PLUGIN_HANDLED;
				
			ArrayGetArray( g_ModesArray, iMode, Data );
			
			g_iRoundMode[ iMode ] = Data[ iRounds ];
			ExecuteForward(g_Fwd_SelectedMode, g_Fwd_Return, id, iMode);
			
			g_bModeIsUsed = true;
			g_bIsUseTimer = false;
			show_menu( id, 0, "^n" )
			
			if( get_pcvar_num(iCvarDhud) )
			{
				for( new i; i < 7; i++ )
					show_dhudmessage( 0, "" );
					
				set_dhudmessage( random_num( 0, 255 ), random_num( 0, 255 ), random_num( 0, 255 ), 0.01, -0.45, 2, 6.0, 5.0, 0.05, 1.5 );
				show_dhudmessage(0, "Террорист выбрал режим - %s", Data[ s_Name ])
			}
		}
	}
	
	return PLUGIN_HANDLED;
}

public plugin_natives()
{
	register_library("deathrun_mode");
	register_native("dm_register_mode", "native_register_mode", 1);
}

public native_register_mode( s_ModeName[ 64 ], iRoundsDelay )
{
	param_convert(1);
	new Data[ _DataMode ];
	Data[ s_Name ] = s_ModeName;
	Data[ iRounds ] = iRoundsDelay;
	ArrayPushArray( g_ModesArray, Data );
	
	g_iNumModes++;
	
	return ( g_iNumModes - 1 );
}

public client_PreThink( id )
{
	if( !g_bIsUseTimer || get_user_team( id ) != 1 || (get_gametime() - g_fLastGameTime[ id ]) < 1.0 )
		return;
		
	if( g_iCountdownTimer[ id ] > 0 )
	{
		g_iCountdownTimer[ id ]--
		Show__ModesMenu( id, g_iPlayerPage[ id ] > -1 ? g_iPlayerPage[ id ] : (g_iPlayerPage[ id ] = 0) );
		g_fLastGameTime[ id ] = get_gametime();
	}
	else
	{
		g_bIsUseTimer = false;
		show_menu( id, 0, "^n" )
	}
}