/*
	v0.1 [04.01.2013] - first release
	v0.2 [04.01.2013] - fixed massive error
	
	By - Turanga_Leela
	http://aghl.ru/forum/ - Russian Half-Life and Adrenaline Gamer Community
*/

#include <amxmodx>
#include <hamsandwich>
#include <fakemeta>

#pragma semicolon 1
#pragma tabsize 0

new

HamHook:g_HamHook_TakeDamage,

bool:g_bValidShoot = false,
g_iWeapon,
g_iBitDamaged = 0,
g_iScore[32],
g_iSniper,
g_iMaxPlayers,
g_iBitAlive = 0;

#define BIT_VALID(%1,%2) 		((%1) & (1 << ((%2) - 1)))
#define BIT_NOT_VALID(%1,%2) 	((~(%1)) & (1 << ((%2) - 1)))
#define BIT_ADD(%1,%2) 			((%1) |= (1 << ((%2) - 1)))
#define BIT_SUB(%1,%2) 			((%1) &= ~(1 << ((%2) - 1)))

#define _BIT_VALID(%1,%2) 		((%1) & (1 << (%2)))
#define _BIT_NOT_VALID(%1,%2) 	((~(%1)) & (1 << (%2)))
#define _BIT_ADD(%1,%2) 		((%1) |= (1 << (%2)))
#define _BIT_SUB(%1,%2) 		((%1) &= ~(1 << (%2)))

#define PLUGIN "OneBulletKills"
#define VERSION "0.2" // [04.01.2013]
#define AUTHOR "Turanga_Leela"

#define IS_PLAYER(%1) (0 < (%1) <= g_iMaxPlayers)
#define IS_SNIPER(%1) ((%1) == g_iSniper)

public client_disconnect(id)
{
	new iPlayer = (id - 1);
	
	_BIT_SUB(g_iBitAlive, iPlayer);
	_BIT_SUB(g_iBitDamaged, iPlayer);
	
	g_iScore[iPlayer] = 0;
}

public Killed_Pre(id, iAttacker, iShouldGib)
{
	BIT_SUB(g_iBitAlive, id);
	
	if(BIT_VALID(g_iBitDamaged, id) && IS_SNIPER(iAttacker) && IS_PLAYER(iAttacker))
	{
		g_iScore[iAttacker - 1]++;
	}
	
	return HAM_IGNORED;
}

public Spawned_Post(id)
{
	if(is_user_alive(id))
	{
		BIT_ADD(g_iBitAlive, id);
	}
	
	BIT_SUB(g_iBitDamaged, id);
	
	return HAM_IGNORED;
}

stock GetChargedBits(iBitSum)
{
	new iReturn = 0;
	
	if(iBitSum)
	{
		enum
		{
			g31 = 1227133513,
			g32 = 941362695
		};

		iBitSum = (iBitSum & g31) + ((iBitSum >> 1) & g31) + ((iBitSum >> 2) & g31);
		iBitSum = ((iBitSum + (iBitSum >> 3)) & g32) + ((iBitSum >> 6) & g32);

		iReturn = ((iBitSum + (iBitSum >> 9) + (iBitSum >> 18) + (iBitSum >> 27)) & 0x3f);
	}

	return iReturn;
}

public WeaponAttack_Pre(iEntity)
{
	if(GetChargedBits(g_iBitAlive) > 0x1)
	{
		if(pev_valid(iEntity))
		{
			new iPlayer = pev(iEntity, pev_owner);
		
			if(IS_PLAYER(iPlayer) && BIT_VALID(g_iBitAlive, iPlayer))
			{
				g_bValidShoot = true;
				g_iWeapon = iEntity;
				g_iScore[(g_iSniper = iPlayer) - 1] = 0;
				
				EnableHamForward(g_HamHook_TakeDamage);
			}
		}
	}
	
	return HAM_IGNORED;
}

public plugin_cfg()
{	
	g_iMaxPlayers = get_maxplayers();
	
	register_plugin(PLUGIN, VERSION, AUTHOR);
	
	DisableHamForward(g_HamHook_TakeDamage = RegisterHam(Ham_TakeDamage, "player", "Damaged_Pre", 0));
	
	RegisterHam(Ham_Spawn, "player", "Spawned_Post", 1);
	RegisterHam(Ham_Killed, "player", "Killed_Pre", 0);
	
	RegisterHam(Ham_Weapon_PrimaryAttack, "weapon_awp", "WeaponAttack_Pre", 0);
	RegisterHam(Ham_Weapon_PrimaryAttack, "weapon_awp", "WeaponAttack_Post", 1);
}

public WeaponAttack_Post(iEntity)
{
	if((g_iWeapon == iEntity) && pev_valid(iEntity))
	{
		DisableHamForward(g_HamHook_TakeDamage);
		
		if(g_bValidShoot)
		{
			g_bValidShoot = false;
			
			if(g_iScore[g_iSniper - 1] > 1)
			{
				new sKillerName[32];
					
				get_user_name(g_iSniper, sKillerName, charsmax(sKillerName));
				client_print(0, print_chat, "[Sniper] -> %s [Killed = %d : By '1' Bullet]", sKillerName, g_iScore[g_iSniper - 1]);
			}
		}
		
		g_iSniper = -1;
	}
	
	return HAM_IGNORED;
}

public Damaged_Pre(id, iInflictor, iAttacker, Float:fDamage, iDamageBits)
{
	if
	(
		(iDamageBits & DMG_BULLET)
	&&
		(fDamage > 0.0)
	)
	
	{
		if(id != g_iSniper && (IS_SNIPER(iInflictor) || IS_SNIPER(iAttacker)))
		{
			BIT_ADD(g_iBitDamaged, id);
		}
		
		else
		{
			BIT_SUB(g_iBitDamaged, id);
		}
	}
	
	else
	{
		BIT_SUB(g_iBitDamaged, id);
	}
	
	return HAM_IGNORED;
}
