#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>
#include <engine>
#include <fun>
#include <cstrike>
#include <WPMGPrintChatColor>

new const resource[] = "models/w_dropbox.mdl"

new ResourcesRadi[33]
new ResourcesMet[33]

new DropBoxMet[1024]
new DropBoxRadi[1024]

new Damagelvl[33]
new Speedlvl[33]
new HPlvl[33]
new APlvl[33]

new PriceDMG[6] = { 0, 50, 100, 200, 400, 800 }
new PriceSpeed[6] = { 0, 10, 20, 40, 80, 160 }
new PriceHP[6] = { 0, 12, 24, 48, 96, 192 }
new PriceAP[6] = { 0, 30, 50, 150, 260, 380 }

new Checked[33]

public plugin_init()
{
	register_plugin("Resources", "0.1 beta", "Chaiker")
	
	RegisterHam(Ham_Killed, "player", "fw_PlayerKilled", 1)
	RegisterHam(Ham_TakeDamage, "player", "fw_PlayerDamage", 1)
	RegisterHam(Ham_Spawn, "player", "fw_PlayerSpawn", 1)
	
	register_touch("Resource", "player", "TouchRes")
	
	register_clcmd("say /res", "cmdres")
	
	register_event("CurWeapon", "Event_CurWeapon", "be","1=1")

	register_event("HLTV", "EventRoundStart", "a", "1=0", "2=0")
}

public plugin_precache()
	precache_model(resource)

public client_connect(id)
{
	ResourcesRadi[id] = 0
	ResourcesMet[id] = 0
	Damagelvl[id] = 0
	Speedlvl[id] = 0
	HPlvl[id] = 0
}

public fw_PlayerDamage(victim, inflictor, attacker, Float:damage, shouldgib)
{
	if(32 < attacker < 0 && !Damagelvl[attacker])
		return HAM_IGNORED
	
	SetHamParamFloat(4, damage * (Damagelvl[attacker] + 1))
	
	return HAM_IGNORED
}

public fw_PlayerSpawn(id)
{
	if(!is_user_alive(id))
		return HAM_IGNORED

	PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "^3Напишите в чат ^4/res^3, чтобы обеспечить себя апгрейдами :)")

	if(APlvl[id])
	{
		remove_task(id)
		Checked[id] = false
		set_task(1.0, "checkap", id, _, _, "b")
	}

	if(!HPlvl[id])
		return HAM_IGNORED

	set_pev(id, pev_health, pev(id, pev_health) * (HPlvl[id] * 0.5 + 1))
	PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "^1У вас ^3%d HP", get_user_health(id))
	
	return HAM_IGNORED
}

public checkap(id)
{
	if(!is_user_alive(id))
		remove_task(id)
	
	if(get_user_armor(id) > 0 && !Checked[id] && get_user_armor(id) < 100)
	{
		set_user_armor(id, floatround(get_user_armor(id) * (APlvl[id] * 0.5 + 1)))
		PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "^1У вас ^3%d AP", get_user_armor(id))
		Checked[id] = true
	}
}

public Event_CurWeapon(id)
{
	if(!is_user_alive(id) || !Speedlvl[id])
		return PLUGIN_CONTINUE

	set_pev(id, pev_maxspeed, pev(id, pev_maxspeed) * (Speedlvl[id] / 5 +1))
	
	return PLUGIN_CONTINUE
}

public cmdres(id)
{
	if(!is_user_alive(id))
		return PLUGIN_CONTINUE

	new title[128], Damage[128], Speed[128], HP[128], AP[128]
	format(title, 127, "\wМеню апгрейдов \y[ \d%d metal %d radioactive \y]", ResourcesMet[id], ResourcesRadi[id])
	if(Damagelvl[id] < 5)
		format(Damage, 127, "\wПовысить урон \d[ %d lvl ] \r+ \y[ %d metal ] \r= \d[ %d lvl ]", Damagelvl[id], PriceDMG[Damagelvl[id] + 1], Damagelvl[id] + 1)
	else
		format(Damage, 127, "\dУрон максимально улучшен")
	if(Speedlvl[id] < 5)
		format(Speed, 127, "\wПовысить скорость \d[ %d lvl ] \r+ \y[ %d radioactive ] \r= \d[ %d lvl ]", Speedlvl[id], PriceSpeed[Speedlvl[id] + 1], Speedlvl[id] + 1)
	else
		format(Damage, 127, "\dСкорость максимально улучшена")
	if(HPlvl[id] < 5)
		format(HP, 127, "\wПовысить HP \d[ %d lvl ] \r+ \y[ %d radioactive ] \r= \d[ %d lvl ]", HPlvl[id], PriceHP[HPlvl[id] + 1], HPlvl[id] + 1)
	else
		format(HP, 127, "\dHP максимально улучшены")
	if(APlvl[id] < 5)
		format(AP, 127, "\wПовысить AP \d[ %d lvl ] \r+ \y[ %d metal ] \r= \d[ %d lvl ]", APlvl[id], PriceAP[APlvl[id] + 1], APlvl[id] + 1)
	else
		format(AP, 127, "\dAP максимально улучшены")

	new menu = menu_create(title,"menu_handler")
	menu_additem(menu, Damage, "1")
	menu_additem(menu, Speed, "2")
	menu_additem(menu, HP, "3")
	menu_additem(menu, AP, "4")
	menu_setprop(menu, MPROP_EXIT, MEXIT_ALL)
	
	menu_display(id, menu, 0)
	
	return PLUGIN_HANDLED
}

public menu_handler(id, menu, item)
{
	if(item == MENU_EXIT)
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}
	
	new data[6],iName[64],access, callback
 	menu_item_getinfo(menu, item, access, data, 5, iName, 63, callback)
	
	new key = str_to_num(data)
	
	switch(key)
	{
		case 1:
		{
			if(Damagelvl[id] == 5)
			{
				cmdres(id)
				return PLUGIN_HANDLED
			}
			if(ResourcesMet[id] < PriceDMG[Damagelvl[id] + 1])
			{
				PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "^3Вам не хватает еще ^1%d metal", PriceDMG[Damagelvl[id] + 1] - ResourcesMet[id])
				cmdres(id)
				return PLUGIN_HANDLED
			}
			Damagelvl[id]++
			ResourcesMet[id] -= PriceDMG[Damagelvl[id]]
		}
		case 2:
		{
			if(Speedlvl[id] == 5)
			{
				cmdres(id)
				return PLUGIN_HANDLED
			}
			if(ResourcesRadi[id] < PriceSpeed[Speedlvl[id] + 1])
			{
				PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "^3Вам не хватает еще ^4%d radioactive", PriceSpeed[Speedlvl[id] + 1] - ResourcesRadi[id])
				cmdres(id)
				return PLUGIN_HANDLED
			}
			Speedlvl[id]++
			ResourcesRadi[id] -= PriceSpeed[Speedlvl[id]]
			set_user_maxspeed(id, get_user_maxspeed(id) * (Speedlvl[id] / 5 + 1))
		}
		case 3:
		{
			if(HPlvl[id] == 5)
			{
				cmdres(id)
				return PLUGIN_HANDLED
			}
			if(ResourcesRadi[id] < PriceHP[HPlvl[id] + 1])
			{
				PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "^3Вам не хватает еще ^4%d radioactive", PriceHP[HPlvl[id] + 1] - ResourcesRadi[id])
				cmdres(id)
				return PLUGIN_HANDLED
			}
			HPlvl[id]++
			ResourcesRadi[id] -= PriceHP[HPlvl[id]]
		}
		case 4:
		{
			if(APlvl[id] == 5)
			{
				cmdres(id)
				return PLUGIN_HANDLED
			}
			if(ResourcesMet[id] < PriceAP[APlvl[id] + 1])
			{
				PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "^3Вам не хватает еще ^1%d metal", PriceAP[APlvl[id] + 1] - ResourcesMet[id])
				cmdres(id)
				return PLUGIN_HANDLED
			}
			APlvl[id]++
			ResourcesMet[id] -= PriceAP[APlvl[id]]
		}
	}
	cmdres(id)
	return PLUGIN_HANDLED
}

public client_PreThink(id)
{
	if(get_user_button(id) & IN_USE && !(get_user_oldbutton(id) & IN_USE))
	{
		PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "^3У вас есть^1 %d metal^4 %d radioactive", ResourcesMet[id], ResourcesRadi[id])
		PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "^1Уровни апгрейдов: ^3урон - %d-й, скорость - %d-й, HP - %d-й", Damagelvl[id], Speedlvl[id], HPlvl[id])
	}
}

public fw_PlayerKilled(victim, attacker, shouldgib)
{
	if(32 < victim < 0)
		return HAM_IGNORED

	new Float:flPlayerOrigin[3], Float:flAttackerOrigin[3], distance, Float:velocity[3]
	entity_get_vector(victim, EV_VEC_origin, flPlayerOrigin)
	if(0 < attacker <= 32)
		entity_get_vector(attacker, EV_VEC_origin, flAttackerOrigin)
	
	new iEntity = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))
	engfunc(EngFunc_SetOrigin, iEntity, flPlayerOrigin)
	if(!pev_valid(iEntity))
	{
		return HAM_IGNORED
	}
	set_pev(iEntity, pev_classname, "Resource")
	engfunc(EngFunc_SetModel, iEntity, resource)
	dllfunc(DLLFunc_Spawn, iEntity)
	set_pev(iEntity, pev_solid, SOLID_SLIDEBOX)
	set_pev(iEntity, pev_movetype, MOVETYPE_TOSS)
	engfunc(EngFunc_SetSize, iEntity, Float:{ -9.83, -13.31, 0.0 }, Float:{ 9.8, 0.85, 10.11 })
	
	flPlayerOrigin[0] -= flAttackerOrigin[0]
	flPlayerOrigin[1] -= flAttackerOrigin[1]
	flPlayerOrigin[2] -= flAttackerOrigin[2]
	if(0 < attacker <= 32)
	{
		distance = get_entity_distance(attacker, iEntity)
		new Float:fl_Time = distance / 400.0
		velocity[0] = flPlayerOrigin[0] / fl_Time
		velocity[1] = flPlayerOrigin[1] / fl_Time
		velocity[2] = flPlayerOrigin[2] / fl_Time
	}
	entity_set_vector(iEntity, EV_VEC_velocity, velocity)
	DropBoxRadi[iEntity] = ResourcesRadi[victim]
	DropBoxMet[iEntity] = ResourcesMet[victim]
	ResourcesRadi[victim] = 0
	ResourcesMet[victim] = 0
	
	return HAM_IGNORED
}

public TouchRes(iEntity, id)
{
	if(!is_user_alive(id))
		return PLUGIN_CONTINUE
	
	new Met = random_num(0, 50), Radi = random_num(0, 20)

	ResourcesMet[id] += DropBoxMet[iEntity] + Met
	ResourcesRadi[id] += DropBoxRadi[iEntity] + Radi
	PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "^1%d metal ^4%d radioactive", DropBoxMet[iEntity] + Met, DropBoxRadi[iEntity] + Radi)

	set_pev(iEntity, pev_flags, FL_KILLME)
	return PLUGIN_CONTINUE
}

public EventRoundStart()
{
	new ent
	while((ent = engfunc(EngFunc_FindEntityByString, ent, "classname", "Resource")) != 0)
		set_pev(ent, pev_flags, FL_KILLME)
}

public zBot_entered_the_game(id)
{
	RegisterHamFromEntity(Ham_Killed, id, "fw_PlayerKilled", 1)
	RegisterHamFromEntity(Ham_Spawn, id, "fw_PlayerSpawn", 1)
	RegisterHamFromEntity(Ham_TakeDamage, id, "fw_PlayerDamage", 1)
}