#include <amxmodx>
#include <cstrike>
#include <dhudmessage>
#include <engine>
#include <fakemeta>
#include <fun>
#include <hamsandwich>

#define PLUGIN "DeathRun Maniac"
#define VERSION "1.0"
#define AUTHOR "Zabava-Server.ru"
#define is_valid_player(%1) (1 <= %1 <= 32)
 
new Float:g_vec[2][3];
new gCreatyVector;
new gMaxplayers;
new Wait = 20;
new gRounds;

new KNF_V_MODEL[64] = "models/maniac/v_knife.mdl"
new KNF_P_MODEL[64] = "models/maniac/p_knife.mdl"
new bool:g_HasKnf[33] = false;

public plugin_init()
{
	register_plugin(PLUGIN,VERSION,AUTHOR);
	register_clcmd("say /maniac","start");
	unregister_forward(FM_Spawn, gCreatyVector, 1);
	register_event("HLTV", "eventRoundStart", "a", "1=0", "2=0");
	RegisterHam(Ham_Killed,"player","ham_player_kill");
	gMaxplayers = get_maxplayers();
	
	register_event("WeapPickup","checkModel","b","1=19");
	register_event("CurWeapon","checkWeapon","be","1=1");
	RegisterHam(Ham_TakeDamage, "player", "fw_TakeDamage");
	RegisterHam(Ham_Spawn, "player", "fwHamPlayerSpawnPost", 1);
	RegisterHam(Ham_Touch, "trigger_hurt", "fwdTouch");
}

public fwdTouch(ent, id)
{
	if(get_user_team(id) == 1 && g_HasKnf[id] == true)
	{
		engfunc(EngFunc_SetOrigin,id,g_vec[0]);
		return HAM_SUPERCEDE;
	}
	return HAM_IGNORED;
}

public ham_player_kill(victim, killer, corpse)
{
	if(g_HasKnf[victim] != true)
		return PLUGIN_HANDLED;
		
	if(is_user_bot(killer) || !is_user_connected(killer))
		return PLUGIN_HANDLED;
	
	new CsTeams:Victim = cs_get_user_team(victim);
	
	if(Victim == CS_TEAM_T)
	{
		new VictimName[32], AttackerName[32];
		get_user_name(victim,VictimName,31);
		get_user_name(killer,AttackerName,31);
		set_dhudmessage(0, 0, 255, -1.0, 0.25, 0, 6.0, 8.0, 1.0, 1.5);
		show_dhudmessage(0, "%s ликвидировал Маньяка!", AttackerName);
		set_lights("#OFF");
		return PLUGIN_HANDLED;
	}
	return PLUGIN_HANDLED;
}

public eventRoundStart(id) 
{
	server_cmd("dr_free 1");
	server_cmd("dr_invis 1");
	set_lights("#OFF");
	gRounds-=1;
}

public start(id)
{
	new CsTeams:team = cs_get_user_team(id);
	if(team == CS_TEAM_T)
	{
		if(gRounds == 5)
		{
			client_print(id, print_chat, "Режим будет доступен через 5 раундов");
			return PLUGIN_HANDLED;
		}
		else if(gRounds == 4 || gRounds == 3 || gRounds == 2)
		{
			client_print(id, print_chat, "Режим будет доступен через %d раунда", gRounds);
			return PLUGIN_HANDLED;
		}
		else if(gRounds == 1)
		{
			client_print(id, print_chat, "Режим будет доступен через 1 ранд");
			return PLUGIN_HANDLED;
		}
		
		Wait = 20;
		gRounds = 5;
		set_user_health(id, 800);
		g_HasKnf[id] = true;
		set_task(1.0, "Waiting", id + 1002365, "", 0, "b");
		set_lights("b");
		set_pev(id, pev_viewmodel2, KNF_V_MODEL);
		set_pev(id, pev_weaponmodel2, KNF_P_MODEL);
		for(new i = 1; i <= gMaxplayers; i++)
		{
			if(!is_user_alive(i) || !is_user_connected(i))
			{
				continue;
			}
			else if(cs_get_user_team(i) == CS_TEAM_CT)
			{
				strip_user_weapons(i);
			}
		}
	}
	else
	{
		client_print(id, print_chat, "Режим может активировать только террорист");
	}
	return PLUGIN_HANDLED;
}

public Waiting(id)
{
	new red = random_num(0, 255);
	new green = random_num(0, 255);
	new blue = random_num(0, 255);
	for(new i = 1; i <= gMaxplayers; i++)
	{
		if(!is_user_alive(i) || !is_user_connected(i))
		{
			continue;
		}
		else if(cs_get_user_team(i) == CS_TEAM_CT)
		{
			strip_user_weapons(i);
			give_item(i, "weapon_knife");
		}
	}
	
	set_dhudmessage(red, green, blue, -1.0, 0.25, 0, 6.0, 0.9, 0.1, 0.1);
	show_dhudmessage(0, "До появления Маньяка осталось: %d...", Wait--);
	server_cmd("dr_free 0");
	server_cmd("dr_invis 0");
	server_cmd("deathrun_mode MANIAC");
	
	if(Wait <= 0)
	{
		remove_task(id);
		id-=1002365;
		teleeed(id);
		return PLUGIN_HANDLED;
	}
	return PLUGIN_HANDLED;
}

public ForwardSpawn(ent)
{
	if(!pev_valid(ent))
		return FMRES_IGNORED;
 
	new classname[32];
	pev(ent, pev_classname, classname, sizeof classname - 1);
	if(equal(classname, "info_player_start"))
	{
		pev(ent,pev_origin,g_vec[0]);
	}
	return FMRES_IGNORED;
}
 
public teleeed(id)
{
	engfunc(EngFunc_SetOrigin,id,g_vec[0]);
	for(new i = 1; i <= gMaxplayers; i++)
	{
		if(!is_user_alive(i) || !is_user_connected(i))
		{
			continue;
		}
		
		if (cs_get_user_team(i) == CS_TEAM_CT)
		{
			strip_user_weapons(i);
			give_item(i, "weapon_knife");
		}
	}
	set_dhudmessage(0, 0, 255, -1.0, 0.25, 0, 6.0, 8.0, 1.5, 1.5);
	show_dhudmessage(0, "Бегите или будете убиты!");
	remove_task(id);
}

public client_connect(id)
{
	g_HasKnf[id] = false;
}

public client_disconnect(id)
{
	g_HasKnf[id] = false;
	remove_task(id+=1002365);
}

public fwHamPlayerSpawnPost(id)
{
	g_HasKnf[id] = false;
	return PLUGIN_HANDLED;
}

public plugin_precache()
{
	precache_model(KNF_V_MODEL);
	precache_model(KNF_P_MODEL);
	gCreatyVector = register_forward(FM_Spawn, "ForwardSpawn", 1);
}

public checkModel(id)
{
	new szWeapID = read_data(2);
	
	if(szWeapID == CSW_KNIFE && g_HasKnf[id] == true)
	{
		set_pev(id, pev_viewmodel2, KNF_V_MODEL);
		set_pev(id, pev_weaponmodel2, KNF_P_MODEL);
	}
	return PLUGIN_HANDLED;
}

public checkWeapon(id)
{
	new plrClip, plrAmmo;
	new plrWeapId;
	
	plrWeapId = get_user_weapon(id, plrClip , plrAmmo);
	
	if(plrWeapId == CSW_KNIFE && g_HasKnf[id])
	{
		checkModel(id);
	}
	else 
	{
		return PLUGIN_CONTINUE;
	}
	return PLUGIN_HANDLED;
}

public fw_TakeDamage(victim, inflictor, attacker, Float:damage)
{
    if(is_valid_player(attacker) && get_user_weapon(attacker) == CSW_KNIFE && g_HasKnf[attacker])
	{
		new gDamage = 100;
		SetHamParamFloat(4, damage * 0 + gDamage);
	}
}