/* AMX Mod script.
*
* HE-CONC 2.0
*  by ThantiK
*
*
* Description:
*  Remember CONC jumping in TFC? -- This adds the knockback to the HE 'nades
*  its great to set higher or lower depending on your wants.  But definately
*  adds some spunk to the game.
*  
* Commands:
*  CVAR - he_push, set higher or lower depending on the effect you want.
*
* Special Thanks:
*  JGHG for the help with setting velocity, and for the code on getting HE coords.
*  Ryan (War3 Expansion guy) for the mathematics and velocity stocks.
*/

#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>
#include <xs>

const DMG_GRENADE = (1<<24)

new g_pCvarPush

public plugin_init()
{ 
	register_plugin("HE Knockback", "2.0", "ThantiK & ConnorMcLeod")

	g_pCvarPush = register_cvar("he_push", "6.0")

	RegisterHam(Ham_TakeDamage, "player", "CBasePlayer_TakeDamage", true)
}

public CBasePlayer_TakeDamage(id, iInflictor, iAttacker, Float:flDamage, bitsDamageType)
{
	if( bitsDamageType & DMG_GRENADE )
	{
		pev(id, pev_dmg_take, flDamage)
		if( flDamage )
		{
			new Float:fVecNadeOrigin[3], Float:fVecPlayerOrigin[3], Float:fVector[3]
			pev(id, pev_origin, fVecPlayerOrigin)
			pev(iInflictor, pev_origin, fVecNadeOrigin)
			xs_vec_sub(fVecPlayerOrigin, fVecNadeOrigin, fVector)
			xs_vec_div_scalar(fVector, get_distance_f(fVecNadeOrigin, fVecPlayerOrigin) / (get_pcvar_float(g_pCvarPush)*flDamage), fVector)
			new Float:fVecVelocity[3]
			pev(id, pev_velocity, fVecVelocity)
			xs_vec_add(fVecVelocity, fVector, fVecVelocity)
			set_pev(id, pev_velocity, fVecVelocity)
		}
	}
}
