/*
*  PSRank for http://www.psychostats.com/ - By: DynAstY
*           (currently for Counter-Strike and Day of Defeat)
*
* SAY COMMANDS:
*
* - /rank // shows all stats
* 
* - /top10 or /top15 // shows all stats
* 
* - /topclan // shows clan page
*
* - /stats // shows your player's stats (name must match in game)
*
* - /search [PLAYER NAME] // does a search with string entered as player name
*
*
* Set amx_psrank_url in amx.cfg to PsychoStats base web URL (trailing forward slash (/) needed)
* Example: amx_psrank_url "http://www.myclanweb.com/stats/"
*
*
*/


#include <amxmodx>

public plugin_init() {
	register_plugin("PSRank", "1.3", "DynAstY")
	register_clcmd("say", "HandleSay", 0, "N/A")
	register_cvar("amx_psrank_url", "http://www.google.com")
}

public client_putinserver(id) {
	if (!is_user_bot(id)) {
		new param[1]
		param[0] = id
		set_task(120.0, "showinfo", id, param, 1)
	}
	return PLUGIN_CONTINUE
}

public showinfo(param[]) {
	client_print(param[0], print_chat, "[AMXX] Say Commands: /stats, /rank, /topclan and /search [playername]")
	return PLUGIN_CONTINUE
}

public HandleSay(id) {
	new sBaseURL[256]
	get_cvar_string("amx_psrank_url",sBaseURL,255)
	new args[256]
	read_argv(1, args, 256)
	
	if(containi(args, "/rank")!=-1 || containi(args, "/top15")!=-1 || containi(args, "/top10")!=-1) { // SAY /rank or /top15
		show_motd(id, sBaseURL, "")
		return PLUGIN_HANDLED
	}

	if(containi(args, "/stats")!=-1) { // SAY /stats
		new name[32]
		get_user_name(id, name, 31)
		new gRankURL[256]
		format(gRankURL, 255,"%sindex.php?page=index&sort=skill&order=desc&search=%s", sBaseURL, name)
		show_motd(id, gRankURL, "")
		return PLUGIN_HANDLED
	}

	if(containi(args, "/search")!=-1) { // SAY /search processing trailing argument
		new t1[32]
		new t2[32]
		parse(args,t1,32,t2,32)
		new gRankURL[256]
		format(gRankURL, 255,"%sindex.php?page=index&sort=skill&order=desc&search=%s", sBaseURL, t2)
		show_motd(id, gRankURL, "")
		return PLUGIN_HANDLED
	}

	if (containi(args, "/topclan")!=-1) { //SAY /topclan 
        	new gRankURL[256] 
        	format(gRankURL, 255,"%sclanlist.php", sBaseURL) 
        	show_motd(id, gRankURL, "") 
        	return PLUGIN_HANDLED 
    	}
	
	return PLUGIN_CONTINUE
}