#include < amxmodx >
#include < geoip >

#define VERSION "1.0"

new g_country[ 33 ][ 5 ];

public plugin_init( ) 
{
	register_plugin( "Country On Name", VERSION, "Bboy Grun" );
	
	register_cvar( "country_on_name", VERSION, FCVAR_SERVER | FCVAR_SPONLY );
	set_cvar_string( "country_on_name", VERSION );
}

public client_putinserver( id )
{
	new ip[ 32 ], country[ 3 ];
	get_user_ip( id, ip, charsmax( ip ) );
	
	if( geoip_code2_ex( ip, country ) )
	{
		format( g_country[ id ], charsmax( g_country[ ] ), "[%s]", country );
	}
	else
	{
		g_country[ id ] = "[??]";
	}
}

public client_disconnect( id )
{
	g_country[ id ][ 0 ] = EOS;
}

#define has_good_name(%1) ( %1[ 0 ] == '[' && %1[ 3 ] == ']' && ( %1[ 1 ] == g_country[ id ][ 1 ] || %1[ 1 ] == '?' ) && ( %1[ 2 ] == g_country[ id ][ 2 ]  || %1[ 2 ] == '?' ) )

public client_infochanged( id )
{
	if( g_country[ id ][ 0 ] )
	{
		new newname[ 32 ];
		get_user_info( id, "name", newname, charsmax( newname ) );
		
		if( !has_good_name( newname ) )
		{
			format( newname, charsmax( newname ), "%s %s", g_country[ id ], newname );
			set_user_info( id, "name", newname );
			
			return PLUGIN_HANDLED;
		}
	}
		
	return PLUGIN_CONTINUE;
}