#include <amxmodx>
#include <amxmisc>

#define PLUGIN "Restart Is Coming!"
#define VERSION "1.2"
#define AUTHOR "AndrewZ"

public plugin_init()
{
	register_plugin( PLUGIN, VERSION, AUTHOR )

	register_dictionary( "amx_ric.txt" )

	register_cvar( "ric_red", "255" )
	register_cvar( "ric_green", "0" )
	register_cvar( "ric_blue", "0" )

	register_cvar( "ric_hud_msg_before_restart", "10" )

	register_cvar( "ric_restart_after", "1500" )
	register_cvar( "ric_hud_msg", "1" )

	register_event( "HLTV", "NewRound", "a", "1=0", "2=0" )
}

public plugin_cfg()
{
	new riccfg[ 32 ]
	get_configsdir( riccfg, charsmax( riccfg ) )

	server_cmd( "exec %s/amx_ric.cfg", riccfg )
}

public NewRound()
{
	remove_task()
	set_task( get_cvar_float( "ric_restart_after" ) - get_cvar_num( "ric_hud_msg_before_restart" ), "restart_msg" )
}

public auto_restart()
{
	server_cmd( "sv_restartround 1" )
}

public restart_msg()
{
	set_task( get_cvar_float( "ric_hud_msg_before_restart" ), "auto_restart" )

	if( get_cvar_num( "ric_hud_msg" ) == 0 )
	{
		return PLUGIN_HANDLED
	}

	for ( new i; i <= get_maxplayers (); i++ )
	{
		if ( is_user_connected ( i ) )
		{
			if (get_cvar_num( "ric_hud_msg" ) == 1 )
			{
				set_hudmessage( get_cvar_num( "ric_red" ), get_cvar_num( "ric_green" ), get_cvar_num( "ric_blue" ), -1.0, 0.35, 2, 1.0, 5.0, 0.1, 0.2, 4 )
				show_hudmessage( i, "%L", i, "HUD_RESTART_MSG", get_cvar_num( "ric_hud_msg_before_restart" ) )
			}

			if (get_cvar_num( "ric_hud_msg" ) == 2 )
			{
				set_hudmessage( random_num( 0, 255 ), random_num( 0, 255 ), random_num( 0, 255 ), -1.0, 0.35, 2, 1.0, 5.0, 0.1, 0.2, 4 )
				show_hudmessage( i, "%L", i, "HUD_RESTART_MSG", get_cvar_num( "ric_hud_msg_before_restart" ) )
			}
		}
	}
	return PLUGIN_HANDLED
}