///////////////////////////////////////////////////////////
// Tracker scheme resource file
//
// sections:
//		Colors			- all the colors used by the scheme
//		BaseSettings		- contains settings for app to use to draw controls
//		Fonts			- list of all the fonts used by app
//		Borders			- description of all the borders
//
///////////////////////////////////////////////////////////
// Default - Portions of this Steam skin were authored by random_n
///////////////////////////////////////////////////////////
Scheme
{
	//////////////////////// COLORS ///////////////////////////
	// color details
	// this is a list of all the colors used by the scheme
	Colors
	{
		// base colors
		"White"				"255 255 255 255"
		"TransparentBlack"		"0 0 0 128"
		"Black"				"0 0 0 255"
		"Blank"				"1 1 1 0"
		"TestColor"			"255 0 0 255"

		// scheme-specific colors	
		"OffWhite"			"216 222 211 255"
		"DullGreen"			"216 222 211 255"
		"Maize"				"224 102 255 255"
		
		"LightGrayBG"			"224 102 255 100"
		"GrayBG"			"122 55 139 50"
		"GrayBG2"			"82 89 78 0"
		
		SecBG				GrayBG2

		"ClayBG"			"38 38 38 10"
		"ClayButtonBG"			"224 102 255 255"
		"ClayEnabled"			"122 55 139 180"
		"ClayKeyFocus"			"89 92 77 255"
		"ClayMouseDown"			"122 55 139 255"
		"ClayDisabledText"		"224 102 255 50"
		"ClayLightGreen"		"139 0 0 255"	// frame button (close X) etc
		"ClayDimLightGreen"		"122 55 139 255"	// frame button and title without focus etc
		"LightClayBG"			"122 55 139 255"	// property sheet interior, active tab
		"LightClayButtonBG"		"125 128 120 255"	// buttons on property sheet interior, active tab
		"DarkClayBG"			"38 38 38 50"		// shadow
		"p_ClayMouseDown"		"122 55 139 170"
		"ClaySheetBottom"		"224 102 255 255"

		"MaizeBG"			"224 102 255 255"	// background color of any selected text or menu item

		"GreenBG"			"76 88 68 255"
		"LightGreenBG"			"122 55 139 20"		// darker background color
		"DarkGreenBG"			"62 70 55 0"		// background color of text edit panes (chat, text entries, etc.)
		
		"DisabledText1"			"117 128 111 255"	// disabled text
		"DisabledText2"			"40 46 34 255"		// overlay color for disabled text (to give that inset look

		"NotificationBodyText"		"White"
		
		// button state text colors
		"Normal"			"143 146 141 255"
		"Over"				"196 181 80 255"		// same as Maize
		"Down"				"35 36 33 255"

		// background colors

		// titlebar colors
		"TitleDimText"			"136 145 128 255"
		"TitleBG"			"TestColor"
		"TitleDimBG"			"TestColor"
		
		// border colors
		"BorderBright"			"128 128 128 255"	// the lit side of a control
		"BorderDark"			"40 46 34 255"		// the dark/unlit side of a control
		"BorderSelection"		"0 0 0 255"		// the additional border color for displaying the default/selected button
	}
	

	///////////////////// BASE SETTINGS ////////////////////////
	//
	// default settings for all panels
	// controls use these to determine their settings
	BaseSettings
	{
		// vgui_controls color specifications
		Border.Bright					"BorderBright"		// the lit side of a control
		Border.Dark					"BorderDark"		// the dark/unlit side of a control
		Border.Selection				"BorderSelection"			// the additional border color for displaying the default/selected button

		CheckButton.BgColor				"DarkGreenBG"
		CheckButton.Border1  				"Border.Dark" 		// the left checkbutton border
		CheckButton.Border2  				"Border.Bright"		// the right checkbutton border
		CheckButton.Check				"Maize"			// color of the check itself

		DragDrop.DragFrame				"255 255 255 192"
		DragDrop.DropFrame				"150 255 150 255"

		Frame.ClientInsetX				10
		Frame.ClientInsetY				35
		Frame.BgColor					"TestColor"
		Frame.OutOfFocusBgColor				"63 70 57 255"
		Frame.FocusTransitionEffectTime			"0"			// time it takes for a window to fade in/out on focus/out of focus
		Frame.TransitionEffectTime			"0.25"			// time it takes for a window to fade in/out on open/close
		Frame.OnDragAlphaDelayTime			"0.15"			// time it takes after clicking the title bar of a window before the alpha multiplier kicks in
		Frame.OnDragAlphaMultiplier			"1.0"			// multiplier applied to alpha while dragging a frame
		Frame.AutoSnapRange				"6"
		Frame.UsesAlphaBlending				1
		FrameSystemButton.Icon				"skins/Flat_Steam/resource/icon_steam"
		FrameSystemButton.DisabledIcon			"skins/Flat_Steam/resource/icon_steam_disabled"

		Notifications.PanelPosition			"BottomRight" 	// Can be "BottomRight", "BottomLeft", "TopRight", "TopLeft"
		Notifications.SlideDirection			"Vertical"  	// Can be "Vertical", "Horizontal", "None" and controls slide effect
		Notifications.FadeInTime			"0.55"		// Controls the time it takes to slide/fade into view
		Notifications.FadeOutTime			"0.55"		// Controls the time it takes to slide/fade out of view
		Notifications.DisplayTime			"6.0"			// Controls the length of time at steady state after fade in and before fade out
		Notifications.StackSize				"3"			// Controls how many panels we will stack before background queuing

		ListPanel.TextColor				White
		ListPanel.BgColor				GrayBG
		ListPanel.SelectedTextColor			White
		ListPanel.SelectedBgColor			DarkClayBG
		ListPanel.SelectedOutOfFocusBgColor		DarkClayBG
		ListPanel.DisabledTextColor			DarkClayBG
		ListPanel.DisabledSelectedTextColor		DarkClayBG
		ListPanel.EmptyListInfoTextColor		OffWhite
		ListPanel.RowHeight				20
		ListPanel.PerPixelScrolling			1

		Menu.TextInset					"6"
		
		Panel.FgColor					"BorderSelection"
		Panel.BgColor					"ClayBG"
		
		RuleColor						"LightClayBG" // color of 1 pixel rule at the bottom of the storefront and community tabs above the footer icons

		PropertySheet.TransitionEffectTime		"0"			// time to change from one tab to another
		PropertySheet.TabGap				3

		RichText.TextColor				White
		RichText.BgColor				GrayBG
		RichText.SelectedTextColor			DarkClayBG
		RichText.SelectedBgColor			MaizeBG
		RichText.InsetX					6
		RichText.InsetY					6
		RichText.URLColor				White

		ScrollBar.Wide					21
		
		SectionedListPanel.CollapserWidth		16
		
		TextEntry.CursorColor				"White"
		TextEntry.IMEBGColor				"225 225 225 255"
		TextEntry.IMEFGColor				"black"
		
		// steam-specific settings
		GamesList.InstalledAppColor			"230 236 224 255"
		GamesList.NotInstalledAppColor			LightGrayBG
		GamesList.ReadyStatusColor			"230 236 224 255"
		GamesList.UpdatingStatusColor			maize
		GamesList.NotInstalledStatusColor		LightGrayBG

		// Friends List colors
		Friends.InGameColor				"176 249 80 255"
		Friends.OnlineColor				"142 202 254 255"
		Friends.OfflineColor			"152 157 155 255"
		DarkGray						"37 37 37 255"
		Friends.PanelDefault			"58 58 58 255"
		Friends.PanelOver				"87 87 87 255"
		Friends.PanelSelected			"17 17 17 255"
		Friends.SectionHeader			"127 135 121 255"
		Friends.NoAvatarOver			"White"
		
		// p2p graph colors
		P2P.DownloadColor				"196 181 80 255"
		P2P.UploadColor					"136 172 187 255"

		P2PBlockStatus.Outline				"100 100 100 255"
		P2PBlockStatus.CompletionBar			"20 0 255 255"
		P2PBlockStatus.CompletionBarBg			"73 73 73 255"

		P2PBlockStatus.BlockStatusUnknown		"255 0 0 192"
		P2PBlockStatus.BlockStatusLow			"73 78 73 255"
		P2PBlockStatus.BlockStatusHigh			"0 94 200 255"

		P2PBlockStatusDetails.c_dling			"255 0 0 255"
		P2PBlockStatusDetails.c_both			"0 127 255 255"
		P2PBlockStatusDetails.c_peer			"200 225 255 255"
		P2PBlockStatusDetails.c_local			"100 180 100 255"
		P2PBlockStatusDetails.c_missing			"255 255 255 255"
		P2PBlockStatusDetails.c_error			"127 127 127 255"
		P2PBlockStatusDetails.c_unused			"0 0 0 255"
	
		ChatOthersTextColor				"white"
		ChatOwnTextColor				"160 160 160 255"
		ChatGradientTop					"39 39 39 255"
		ChatGradientBottom				"102 104 99 255"
		Slider.NobColor					"OffWhite"
		
		AchievementPopup.TitleColor		"white"
		AchievementPopup.DescriptionColor	"180 180 180 255"
		
		GiftOnlyInfo.ImagePanelColor	"GrayBG"
	}
	
	//
	//////////////////// CONTROLS //////////////////////////////
	//
	// describes how controls are rendered
	
	Controls
	{
		// typical control states:	default  disabled
		// button control states:	keyfocus  mouseover  mousedown  keyfocus_mouseover  defaultbutton  defaultbutton_mouseover
		// radio/checkbox states:	selected  selected_disabled  selected_keyfocus  selected_mouseover  selected_mousedown  selected_keyfocus_mouseover
		
		// color types:				textcolor  shadowtextcolor  selectedtextcolor  selectedbgcolor
		
		BaseControls
		{
			Button
			{
				textcolor	White
				bgcolor		ClayButtonBG
				appearance		ButtonBorder
				
				mousedown	
				{
					appearance ButtonDepressedBorder
					textcolor	Maize
				}
				
				keyfocus
				{ 
					appearance ButtonKeyFocusBorder
					textcolor Maize
				}
				mouseover	{ textcolor Maize }

				disabled
				{
					appearance			ButtonBorderDisabled
					textcolor		ClayDisabledText
					shadowtextcolor		Blank
				}
				
				keyfocus_mouseover		
				{ 
					appearance ButtonKeyFocusBorder
					textcolor Maize
				}
				
				defaultbutton
				{ 
					appearance		ButtonBorderDefault
					textcolor	White
				}
				defaultbutton_mouseover		
				{ 
					appearance		ButtonBorderDefault
					textcolor	Maize
				}
			}
			
			GripPanel
			{
				textcolor	TestColor
				bgcolor		TestColor
			}
			
			CheckButton
			{
				textcolor	OffWhite
				image		Graphics/chkUnselStd
				mouseover
				{
					textcolor Maize
					image	Graphics/chkUnselStd
				}
				mousedown	
				{
					textcolor Maize
					image Graphics/chkSelDown
				}
				selected	
				{
					image Graphics/chkSelStd
				}
				
				keyfocus
				{
					textcolor Maize 
					image	Graphics/chkUnselFocus
				}
				
				keyfocus_mouseover
				{
					textcolor Maize 
					image	Graphics/chkUnselFocus
				}
				
				selected_mouseover	
				{ 
					textcolor Maize 
					image	Graphics/chkSelStd
				}
				
				selected_mousedown
				{
					textcolor Maize
					image	Graphics/chkSelDown
				}
				
				selected_keyfocus
				{
					textcolor Maize
					image	Graphics/chkSelFocus
				}
				
				selected_keyfocus_mouseover
				{
					textcolor Maize  
					image	Graphics/chkSelFocus
				}
				
				disabled
				{
					textcolor		DisabledText1
					image Graphics/chkUnselDis
				}
				selected_disabled
				{
					textcolor		ClayDisabledText
					shadowtextcolor		Blank
					image	Graphics/chkSelDis
				}
			}
			
			CheckButtonList
			{
				appearance		InsetBorder
			}
			
			ComboBox
			{
				textcolor	OffWhite
				selectedtextcolor	Maize
				appearance		InputBorder
				mouseover	{ textcolor Maize }
				mousedown	{ textcolor White }
				keyfocus	{ textcolor Maize }
				disabled	{ appearance InputBorderDisabled textcolor ClayDisabledText }
			}
			
			ComboBoxButton
			{
				textcolor	OffWhite
				bgcolor		Blank
				mouseover	{ textcolor Maize }
				disabled	{ textcolor LightGrayBG }
			}
			
			ContextLabel
			{
				textcolor	OffWhite
			}
			
			Divider
			{
				appearance		InsetBorder
			}
			
			Frame
			{
				appearance		FrameBorder
			}
			
			FrameButton
			{
				appearance		NoBorder
				textcolor	OffWhite
				bgcolor		Blank
				mousedown	{ appearance InsetBorder }
				keyfocus	{ appearance ButtonKeyFocusBorder }
				outoffocus	
				{
					appearance NoBorder
					textColor ClayDimLightGreen
				}
			}
		
			FrameSystemButton
			{
				appearance		NoBorder
				textcolor	ClayLightGreen
				bgcolor		Blank
			}
			
			FrameTitle
			{
				textcolor	OffWhite
				bgcolor		Blank
				outoffocus	{ textcolor	ClayDimLightGreen }
			}
			
			FrameBRGripPanel
			{
				textcolor		Blank
				shadowtextcolor		Blank
				appearance		ResizeBorder
				mouseover
				{
					appearance	ResizeMouseoverBorder
				}
				mousedown	
				{
					appearance ResizeMousedownBorder
				}
				disabled
				{
					appearance	ResizeBorder
				}
			}

			CChatTitlePanel
			{
				appearance		ChatTitlePanelDefault
			}
			CChatFriendTitlePanel
			{
				appearance	ChatFriendTitlePanelDefault
			}	
			
			CChatHistoryPanel
			{
				appearance		ChatHistoryPanelDefault
				textcolor	White
				scrollbar_visible
				{
					appearance	ChatHistoryPanelDefault
				}
			}
			CChatTextEntry
			{
				appearance		ChatInputBorder
				
				textcolor			White
				bgcolor				Blank
				selectedtextcolor	Black	
				selectedbgcolor		Maize
				shadowtextcolor		White		// this is the cursor color
				
				disabled
				{
					appearance		ChatInputBorderDisabled
					textcolor			ClayDisabledText
					bgcolor				Blank
					selectedtextcolor	Black	
					selectedbgcolor		OffWhite
				}		
			}
			CChatUserPanel
			{
				appearance		ListPanelSlantBGWithBorder
				scrollbar_visible
				{
					appearance	ListPanelSlantBGWithBorder
				}
			}

			CFriendsListUserPanel
			{
				appearance		ListPanelSlantBGNoBorder
			}

			CMiniGamesListPanel
			{
				appearance		p_ListPanelInteriorBorder
				scrollbar_visible
				{
					appearance	p_ListPanelScrollInteriorBorder
				}
			}		

			
			CChatInviteBG
			{
				appearance		ChatInviteBG
			}
			
			CVoiceChatOffBG
			{
				appearance		VoiceChatOffBG
			}
			
			CVoiceChatOnBG
			{
				appearance		VoiceChatOnBG
			}
			
			
			// user-menu button
			CChatTitlePanelAffordance
			{
				appearance	ChatTitlePanelDefault
				textcolor	OffWhite
				bgcolor	Blank

				mouseover
				{
					textcolor	Maize
					appearance	FriendPanelAffordanceMouseover
				}
				mousedown
				{
					appearance	FriendPanelAffordanceMousedown
				}
				keyfocus
				{
					appearance	FriendPanelAffordanceMouseover
				}
				keyfocus_mouseover
				{
					appearance	FriendPanelAffordanceMouseover
				}
			}
			
			CFriendPanel
			{
				appearance		FriendPanelDefault
				mouseover
				{
					appearance	FriendPanelMouseOver
				}
				selected
				{
					appearance	FriendPanelSelected
				}
				compact
				{
					appearance		Blank
					bgcolor	Blank
				}
				compact_selected
				{
					appearance		Blank
					bgcolor	Blank
				}
			}

			// user-menu button
			CFriendPanelAffordance
			{
				appearance	Blank
				bgcolor	Blank
				mouseover
				{
					appearance	FriendPanelAffordanceMouseover
				}
				mousedown
				{
					appearance	FriendPanelAffordanceMousedown
				}
				keyfocus
				{
					appearance	FriendPanelAffordanceMouseover
				}
				keyfocus_mouseover
				{
					appearance	FriendPanelAffordanceMouseover
				}
			}

			CFriendsListSectionHeader
			{
				appearance	Blank
				textcolor			Friends.SectionHeader		// group name color
				shadowtextcolor		Friends.SectionHeader		// secondary text (3 IN-GAME, 6 ONLINE) color
				bgcolor		GrayBG2
			}
			
			// group-menu button
			CFriendsListSectionAffordance
			{
				appearance	Blank
				textcolor	Friends.SectionHeader
				bgcolor	Blank
				mouseover
				{
					appearance	FriendPanelAffordanceListMouseover
					textcolor	Maize
				}
				mousedown
				{
					bgcolor		Black
				}
				keyfocus
				{
					bgcolor		Black
				}
				keyfocus_mouseover
				{
					bgcolor		Black
				}
			}

			// in-game overlay
			CTaskbarButton
			{
				appearance	OverlayBorder_off
				textcolor	White
				bgcolor		Blank
				
				mouseover
				{
					textcolor	Maize
				}

				selected
				{
					appearance	OverlayBorder_on
					bgcolor		Blank
				}
				
				selected_mouseover
				{
					appearance	OverlayBorder_on
					textcolor	Maize
					bgcolor		Blank
				}
			}
			
			COverlayTaskbar
			{
				bgcolor		Black
			}
			
	
			COverlayMain
			{
				bgcolor		"0 0 0 128"
			}
			
			GraphPanel
			{
				textcolor	Maize
				bgcolor		DarkClayBG
				appearance		InsetBorder
			}

			HTML
			{
				bgcolor		Blank
				appearance			HTMLInteriorBorder

			}
			
			HTMLInterior
			{
				bgcolor			Blank
			}
			
				
			icon_button_news
			{
				textcolor		Normal
				bgcolor			Blank
				appearance			NewsBorder
				mousedown		{ appearance NewsBorder_mousedown textcolor	Down }
				keyfocus		{ appearance NewsBorder textcolor Normal }
				mouseover		{ appearance NewsBorder_mouseover textcolor Over }
				disabled		{ appearance NewsBorder textcolor ClayDisabledText shadowtextcolor Blank }
				keyfocus_mouseover	{ appearance NewsBorder_mouseover textcolor Over } 
				defaultbutton		{ appearance NewsBorder textcolor Normal }
				defaultbutton_mouseover	{ appearance NewsBorder_mouseover textcolor Over }
			}
		
			icon_button_friends
			{
				textcolor		Normal
				bgcolor			Blank
				appearance			FriendsBorder
				mousedown		{ appearance FriendsBorder_mousedown textcolor	Down }
				keyfocus		{ appearance FriendsBorder textcolor Normal }
				mouseover		{ appearance FriendsBorder_mouseover textcolor Over }
				disabled		{ appearance FriendsBorder textcolor ClayDisabledText shadowtextcolor Blank }
				keyfocus_mouseover	{ appearance FriendsBorder_mouseover textcolor Over } 
				defaultbutton		{ appearance FriendsBorder textcolor Normal }
				defaultbutton_mouseover	{ appearance FriendsBorder_mouseover textcolor Over }
			}

			icon_button_servers
			{
				textcolor		Normal
				bgcolor			Blank
				appearance			ServersBorder
				mousedown		{ appearance ServersBorder_mousedown textcolor	Down }
				keyfocus		{ appearance ServersBorder textcolor Normal }
				mouseover		{ appearance ServersBorder_mouseover textcolor Over }
				disabled		{ appearance ServersBorder textcolor ClayDisabledText shadowtextcolor Blank }
				keyfocus_mouseover	{ appearance ServersBorder_mouseover textcolor Over } 
				defaultbutton		{ appearance ServersBorder textcolor Normal }
				defaultbutton_mouseover	{ appearance ServersBorder_mouseover textcolor Over }
			}
			
			icon_button_settings
			{
				textcolor		Normal
				bgcolor			Blank
				appearance			SettingsBorder
				mousedown		{ appearance SettingsBorder_mousedown textcolor	Down }
				keyfocus		{ appearance SettingsBorder textcolor Normal }
				mouseover		{ appearance SettingsBorder_mouseover textcolor Over }
				disabled		{ appearance SettingsBorder textcolor ClayDisabledText shadowtextcolor Blank }
				keyfocus_mouseover	{ appearance SettingsBorder_mouseover textcolor Over } 
				defaultbutton		{ appearance SettingsBorder textcolor Normal }
				defaultbutton_mouseover	{ appearance SettingsBorder_mouseover textcolor Over }
			}
			
			icon_button_support
			{
				textcolor		Normal
				bgcolor			Blank
				appearance			SupportBorder
				mousedown		{ appearance SupportBorder_mousedown textcolor	Down }
				keyfocus		{ appearance SupportBorder textcolor Normal }
				mouseover		{ appearance SupportBorder_mouseover textcolor Over }
				disabled		{ appearance SupportBorder textcolor ClayDisabledText shadowtextcolor Blank }
				keyfocus_mouseover	{ appearance SupportBorder_mouseover textcolor Over } 
				defaultbutton		{ appearance SupportBorder textcolor White }
				defaultbutton_mouseover	{ appearance SupportBorder_mouseover textcolor Over }
			}
			
			icon_button_MiniMeShrink
			{
				bgcolor			Blank
				appearance			MiniMeShrinkBorder
				mousedown		{ appearance MiniMeShrinkBorder textcolor	Blank }
				keyfocus		{ appearance MiniMeShrinkBorder textcolor Blank }
				mouseover		{ appearance MiniMeShrinkBorder_mouseover textcolor Blank }
				disabled		{ appearance MiniMeShrinkBorder textcolor Blank shadowtextcolor Blank }
				keyfocus_mouseover	{ appearance MiniMeShrinkBorder_mouseover textcolor Blank } 
				defaultbutton		{ appearance MiniMeShrinkBorder textcolor Blank }
				defaultbutton_mouseover	{ appearance MiniMeShrinkBorder_mouseover textcolor Blank }
			}

			icon_button_MiniMeExpand
			{
				bgcolor			Blank
				appearance			MiniMeExpandBorder
				mousedown		{ appearance MiniMeExpandBorder textcolor	Blank }
				keyfocus		{ appearance MiniMeExpandBorder textcolor Blank }
				mouseover		{ appearance MiniMeExpandBorder_mouseover textcolor Blank }
				disabled		{ appearance MiniMeExpandBorder textcolor Blank shadowtextcolor Blank }
				keyfocus_mouseover	{ appearance MiniMeExpandBorder_mouseover textcolor Blank } 
				defaultbutton		{ appearance MiniMeExpandBorder textcolor Blank }
				defaultbutton_mouseover	{ appearance MiniMeExpandBorder_mouseover textcolor Blank }
			}

			icon_button_home
			{
				bgcolor			Blank
				appearance			HomeBorder
				mousedown		{ appearance HomeBorder_down textcolor	Blank }
				keyfocus		{ appearance HomeBorder textcolor	Blank }
				mouseover		{ appearance HomeBorder_over textcolor	Blank }
				disabled		{ appearance HomeBorder textcolor Blank shadowtextcolor Blank }
				keyfocus_mouseover	{ appearance HomeBorder_over textcolor	Blank } 
				defaultbutton		{ appearance HomeBorder textcolor	Blank }
				defaultbutton_mouseover	{ appearance HomeBorder_over textcolor	Blank }
			}
			
			icon_button_reload
			{
				bgcolor			Blank
				appearance			ReloadBorder
				mousedown		{ appearance ReloadBorder_down textcolor	Blank }
				keyfocus		{ appearance ReloadBorder textcolor	Blank }
				mouseover		{ appearance ReloadBorder_over textcolor	Blank }
				disabled		{ appearance ReloadBorder textcolor Blank shadowtextcolor Blank }
				keyfocus_mouseover	{ appearance ReloadBorder_over textcolor	Blank } 
				defaultbutton		{ appearance ReloadBorder textcolor	Blank }
				defaultbutton_mouseover	{ appearance ReloadBorder_over textcolor	Blank }
			}
			
			icon_button_back
			{
				bgcolor			Blank
				appearance			BackBorder
				mousedown		{ appearance BackBorder_down textcolor	Blank }
				keyfocus		{ appearance BackBorder textcolor	Blank }
				mouseover		{ appearance BackBorder_over textcolor	Blank }
				disabled		{ appearance BackBorder_disabled textcolor Blank shadowtextcolor Blank }
				keyfocus_mouseover	{ appearance BackBorder_over textcolor	Blank } 
				defaultbutton		{ appearance BackBorder textcolor	Blank }
				defaultbutton_mouseover	{ appearance BackBorder_over textcolor	Blank }
			}
			
			icon_button_forward
			{
				bgcolor			Blank
				appearance			ForwardBorder
				mousedown		{ appearance ForwardBorder_down textcolor	Blank }
				keyfocus		{ appearance ForwardBorder textcolor	Blank }
				mouseover		{ appearance ForwardBorder_over textcolor	Blank }
				disabled		{ appearance ForwardBorder_disabled textcolor Blank shadowtextcolor Blank }
				keyfocus_mouseover	{ appearance ForwardBorder_over textcolor	Blank } 
				defaultbutton		{ appearance ForwardBorder textcolor	Blank }
				defaultbutton_mouseover	{ appearance ForwardBorder_over textcolor	Blank }
			}
			
			icon_button_stop
			{
				bgcolor			Blank
				appearance			StopBorder
				mousedown		{ appearance StopBorder_down textcolor	Blank }
				keyfocus		{ appearance StopBorder textcolor	Blank }
				mouseover		{ appearance StopBorder_over textcolor	Blank }
				disabled		{ appearance StopBorder textcolor Blank shadowtextcolor Blank }
				keyfocus_mouseover	{ appearance StopBorder_over textcolor	Blank } 
				defaultbutton		{ appearance StopBorder textcolor	Blank }
				defaultbutton_mouseover	{ appearance StopBorder_over textcolor	Blank }
			}
			
			Label
			{
				textcolor			OffWhite
				bgcolor				Blank
				selectedtextcolor	Maize				// used for when a label is associated with a control that has focus
			}
			
			LabelDull
			{
				textcolor			DullGreen
				bgcolor				Blank
				selectedtextcolor	Maize
			}

			LabelBright
			{
				textcolor			White
				bgcolor				Blank
				selectedtextcolor	Maize
			}
			
			LabelListEntryLeft
			{
				textcolor			ClayLightGreen
				bgcolor				GrayBG
			}
			
			LabelListEntryRight
			{
				textcolor			OffWhite
				bgcolor				GrayBG
			}

			ListPanel
			{
				bgcolor		Blank
				appearance		HTMLInteriorBorder
			}
			
			ListPanelCheckBox
			{
				textcolor	OffWhite
				image		Graphics/chkUnselStd
				selected	
				{
					image Graphics/chkSelStd
				}
				selected_mouseover	
				{ 
					image Graphics/chkSelStd
				}
				selected_mousedown
				{
					image Graphics/chkSelStd
				}
				selected_keyfocus
				{
					image Graphics/chkSelStd
				}
				selected_keyfocus_mouseover
				{
					image Graphics/chkSelStd
				}
			}
			
			ListPanelInterior
			{
				bgcolor		GrayBG
				appearance		ListPanelInteriorBorder
				scrollbar_visible
				{
					appearance	ListPanelInteriorBorder
				}
			}
			
			ListPanelSectionHeader
			{
				textcolor	Maize
				bgcolor		LightGrayBG
			}

			ListPanelSectionCollapser
			{
				textcolor	Friends.SectionHeader
				bgcolor		GrayBG
			}
			
			ListPanelColumnHeader	
			{
				appearance		ListPanel.HeaderButtonBorder
				textcolor   OffWhite
				bgcolor		Blank
				mousedown
				{
					textcolor DullGreen
				}
				mouseover	{ textcolor Maize }
			}
			
			ListPanelDragger
			{
				appearance		ListPanelDraggerBorder
			}

			ListViewPanel
			{
				appearance		InsetBorder
			}
			
			Menu
			{
				appearance		MenuBorder
				bgcolor		LightGreenBG
			}

			MenuBar		
			{
				bgcolor		Blank
			}
			
			MenuBarItem
			{
				textcolor	OffWhite
				bgcolor		Blank
				mouseover	{ textcolor Maize }
				mousedown	{ textcolor DullGreen }
				selected	{ textcolor Maize }
			}
			
			MenuItem
			{
				textcolor	OffWhite
				bgcolor		DarkClayBG
				mouseover	{ textcolor white bgcolor MaizeBG }
				disabled
				{
					textcolor			DisabledText1
//					shadowtextcolor		DisabledText1
				}
			}
			
			MenuSeparator
			{
				textcolor	Blank
				bgcolor		Blank
				appearance		
				{ 
					render_bg 
					{ 
						"1"	"fill( x0, y0, x1, y1, DarkClayBG )" 
						"2"	"image( x0 + 2, y0 + 1, x0 + 12, y0 + 2, Graphics/mnuSepLeft)"
						"3"	"image( x0 + 12, y0 + 1, x1 - 12, y0 + 2, Graphics/mnuSepCenter)"
						"4"	"image( x1 - 12, y0 + 1, x1 - 2, y0 + 2, Graphics/mnuSepRight)"
					} 
				}
			}
			
			NotificationFrame
			{
				appearance		ToolTipBorder
				textcolor		White
				bgcolor			DarkClayBG
			}
			
			PanelListPanel
			{
				appearance		InsetBorder
			}
			
			PanelHorizListPanel
			{
				appearance		InsetBorder
			}
			
			PageTab
			{
				textcolor	OffWhite
				bgcolor		GrayBG
				appearance		TabBorder
				mouseover	{ textcolor Maize }
				mousedown	{ textcolor DullGreen }
				active	
				{ 
					appearance		TabActiveBorder 
					textcolor	Maize 
					bgcolor		LightGrayBG 
				}
				keyfocus		
				{
					appearance TabKeyfocusBorder
					textcolor Maize
				}
				keyfocus_mouseover
				{
					appearance TabKeyfocusBorder
					textcolor Maize
				}
			}
			
			PropertyPage
			{
				appearance		PropertyPageBorder
			}
			
			SteamGamesPage
			{
				bgcolor		TestColor
			}

				
			PropertySheet
			{
				bgcolor		Blank
				appearance		PropertySheetBorder
				bgcolor		Blank
				topleft		{ appearance PropertySheetBorderTopLeft }
				topright	{ appearance PropertySheetBorderTopRight }
			}
			
			ProgressBar
			{
				textcolor	Maize
				bgcolor		DarkGreenBG
				appearance		InputBorder
			}
			
			RadioButton
			{
				
				textcolor	OffWhite
				image		Graphics/radUnselStd
				mouseover
				{
					textcolor Maize
					image	Graphics/radUnselStd
				}
				mousedown	
				{
					textcolor Maize
					image Graphics/radSelDown
				}
				selected	
				{
					image Graphics/radSelStd
				}
				
				keyfocus
				{
					textcolor Maize 
					image	Graphics/radUnselFocus
				}
				
				keyfocus_mouseover
				{
					textcolor Maize 
					image	Graphics/radUnselFocus
				}
				
				selected_mouseover	
				{ 
					textcolor Maize 
					image	Graphics/radSelStd
				}
				
				selected_mousedown
				{
					textcolor Maize
					image	Graphics/radSelDown
				}
				
				selected_keyfocus
				{
					textcolor Maize
					image	Graphics/radSelFocus
				}
				
				selected_keyfocus_mouseover
				{
					textcolor Maize  
					image	Graphics/radSelFocus
				}
				
				disabled
				{
					textcolor		DisabledText2
					image Graphics/radUnselDis
				}
				selected_disabled
				{
					textcolor		ClayDisabledText
					shadowtextcolor		Blank
					image	Graphics/radSelDis
				}
			}
			
			RichText
			{
				appearance		HTMLInteriorBorder
			}
			
			RichTextInterior
			{
				
				scrollbar_visible
				{
					
				}
			}
			
			ScrollBarSlider
			{
				//bgcolor TestColor
				mouseover	// doesn't work, wah
				{ 
				}
				mousedown	// doesn't work, wah
				{
				}
				slider		
				{
					appearance ScrollBarSliderBorder
					bgcolor Blank
				}
				slider_horiz
				{
					appearance Horiz_ScrollBarSliderBorder
					bgcolor Blank
				}
			}
			
			ScrollBarButton
			{
				appearance		ScrollBarButtonBorder
				textcolor	OffWhite
				mouseover	
				{
					textcolor White
				}
				mousedown	// doesn't work, wah
				{
				}
			}
			
			SectionedListPanel
			{
				bgcolor		Blank
				appearance		ListPanelBorderSimple
			}

			SectionedListPanelInterior
			{
				bgcolor		Blank
			}
			
			SectionedListPanelItem
			{
				textcolor	OffWhite
				// set a appearance just to use the inset to adjust the text position
				appearance	{ inset "0 0 0 0" }
				
				selected
				{
					textcolor	White
					
					appearance
					{
						inset "0 0 0 0"
						render_bg
						{
							"0" "fill( x0 - 3, y0, x1, y1, Black)" 
						}
					}
				}
			}
			
			SectionedListPanelHeader
			{
				textcolor	Maize
				
				appearance
				{
					render_bg
					{ 
						"2"	"image( x0 - 12, y1 - 2, x0, y1 - 1, Graphics/mnuSepLeft)"
						"3"	"image( x0, y1 - 2, x1 - 12, y1 - 1, Graphics/mnuSepCenter)"
						"4"	"image( x1 - 12, y1 - 2, x1 - 2, y1 - 1, Graphics/mnuSepRight)"
					} 
				}	
			}
			
			SectionedListPanelCollapser
			{
				textcolor	Friends.SectionHeader
				bgcolor		Blank
			}
			
			Slider
			{
				bgcolor				Blank
				textcolor			LightClayButtonBG
				selectedtextcolor	ClayBG		// this is the color to draw the tracks
				
				disabled
				{
					textcolor			DisabledText1
					shadowtextcolor		DisabledText2
				}
			}
			
			SplitterHandle
			{
				appearance		InsetBorder
			}
			
			TextEntry
			{
				appearance		InputBorder
				
				textcolor			White
				bgcolor				Blank
				selectedtextcolor	Black	
				selectedbgcolor		Maize
				
				disabled
				{
					appearance		InputBorderDisabled
					textcolor			ClayDisabledText
					bgcolor				Blank
					selectedtextcolor	Black	
					selectedbgcolor		OffWhite
				}		
			}

			TextEntryGiftWizardMessage
			{
				appearance		InputBorderWithHeart
				
				textcolor			White
				bgcolor				Blank
				selectedtextcolor	Black	
				selectedbgcolor		White
				
				disabled
				{
					appearance		InputBorderDisabled
					textcolor			ClayDisabledText
					bgcolor				Blank
					selectedtextcolor	Black	
					selectedbgcolor		OffWhite
				}		
			}	
		
			ToggleButton
			{
				textcolor	OffWhite
				bgcolor		Blank
				appearance		ButtonBorder
				
				mousedown		{ appearance ButtonDepressedBorder textcolor Maize }
				mouseover		{ textcolor Maize }
				keyfocus		{ textcolor OffWhite }
				keyfocus_mouseover	{ textcolor Maize }
				
				selected			{ appearance ButtonDepressedBorder textcolor Maize }
				selected_mouseover		{ appearance ButtonDepressedBorder textcolor Maize }
				selected_mousedown		{ appearance ButtonDepressedBorder textcolor Maize }
				selected_keyfocus		{ appearance ButtonDepressedBorder textcolor Maize }
				selected_keyfocus_mouseover	{ appearance ButtonDepressedBorder textcolor Maize }

				disabled
				{
					appearance			ButtonBorderDisabled
					textcolor		DisabledText2
					shadowtextcolor		Blank
				}
			}
			
			TooltipWindow
			{
				textcolor	White
				appearance		ToolTipBorder
			}
			
			TreeView
			{
				textcolor	Blank
				bgcolor		White
				appearance		{}
			}
			
			TreeNode
			{
				textcolor	White
				bgcolor		Blank
			}
			
			TreeViewSubPanel
			{
				bgcolor		DarkClayBG
			}
			
			TreeNodeText
			{
				textcolor	White
				bgcolor		Blank
				selectedtextcolor	White
				selectedbgcolor		MaizeBG
			}
			
			URLLabel
			{
				textcolor			White
				bgcolor				Blank
			}

			WizardPanel
			{
				bgcolor		Blank
				appearance		FrameBorder
			}
			
			WizardSubPanel
			{ 
				appearance		WizardExperimentBorder
				bgcolor		Blank
			}
		}

		// specific ovverides for controls inside of the friends dialog or friends chat dialogs
		FriendsControls
		{
			SectionedListPanelCollapser
			{
				textcolor	Friends.SectionHeader
				bgcolor		Blank
				
				expanded
				{
					image	Graphics/icon_collapse_friends
				}

				collapsed
				{
					image	Graphics/icon_expand_friends
				}

				expanded_focus
				{
					image	Graphics/icon_collapse
				}

				collapsed_focus
				{
					image	Graphics/icon_expand
				}
			}
		}		

		SendGiftControls
		{
			ListPanel.TextColor				OffWhite
			ListPanel.BgColor					GrayBG
			ListPanel.SelectedTextColor			OffWhite
			ListPanel.SelectedBgColor			DarkClayBG
			ListPanel.SelectedOutOfFocusBgColor		DarkClayBG
			ListPanel.DisabledTextColor			LightGrayBG
			ListPanel.DisabledSelectedTextColor		LightGrayBG
			ListPanel.EmptyListInfoTextColor		OffWhite
			ListPanel.RowHeight				20
			ListPanel.PerPixelScrolling			1

			ListPanel
			{
				bgcolor		Blank
			}


			ListPanelInterior
			{
				bgcolor			GrayBG
				appearance		p_ListGiftSendInteriorBorder
				scrollbar_visible
				{
					appearance	p_ListGiftSendScrollInteriorBorder
				}
			}

		}


		// specific ovverides for controls inside of the games page dialog
		GamesPageControls
		{
			SectionedListPanelCollapser
			{
				textcolor	LightGrayBG
				bgcolor		GrayBG
				
				expanded
				{
					image	Graphics/icon_collapse
				}

				collapsed
				{
					image	Graphics/icon_expand
				}

				expanded_focus
				{
					image	Graphics/icon_collapse_over
				}

				collapsed_focus
				{
					image	Graphics/icon_expand_over
				}
			}

			ListPanelSectionCollapser
			{
				textcolor	LightGrayBG
				bgcolor		GrayBG
				
				expanded
				{
					image	Graphics/icon_collapse
				}

				collapsed
				{
					image	Graphics/icon_expand
				}

				expanded_focus
				{
					image	Graphics/icon_collapse_over
				}

				collapsed_focus
				{
					image	Graphics/icon_expand_over
				}
			}


			ListPanel
			{
				bgcolor		Blank
			}


			ListPanelInterior
			{
				bgcolor			GrayBG
				appearance		p_ListPanelInteriorBorder
				scrollbar_visible
				{
					appearance	p_ListPanelScrollInteriorBorder
				}
			}
			
			ListPanelSectionHeader
			{
				textcolor	Maize
				bgcolor		LightGrayBG
			}

			RichTextInterior
			{
				appearance		p_RichTextInteriorBorder
				scrollbar_visible
				{
					appearance	p_RichTextScrollInteriorBorder
				}
			}

			SectionedListPanelInterior
			{
				bgcolor		Blank
			}

			Button
			{
				textcolor	White
				bgcolor		ClayButtonBG
				appearance		p_ButtonBorder
				
				mousedown
				{
					appearance p_ButtonDepressedBorder
					textcolor	Maize
				}

				keyfocus	
				{ 
					appearance p_ButtonKeyFocusBorder
					textcolor Maize
				}
				mouseover
				{
					textcolor Maize
				}
				
				keyfocus_mouseover		
				{ 
					appearance p_ButtonKeyFocusBorder
					textcolor Maize
				}
				
				defaultbutton
				{ 
					appearance p_ButtonBorderDefault
					textcolor White
				}
				
				defaultbutton_mouseover		
				{ 
					appearance p_ButtonBorderDefault
					textcolor Maize
				}

				disabled
				{
					appearance				p_ButtonBorderDisabled
					textcolor			LightGrayBG
					shadowtextcolor		Blank
				}
			}

			ToggleButton
			{
				textcolor	OffWhite
				bgcolor		Blank
				appearance		p_ButtonBorder
				
				mousedown		{ appearance p_ButtonDepressedBorder textcolor Maize }
				mouseover		{ textcolor Maize }
				keyfocus		{ textcolor OffWhite }
				keyfocus_mouseover	{ textcolor Maize }
				
				selected			{ appearance p_ButtonDepressedBorder textcolor Maize }
				selected_mouseover		{ appearance p_ButtonDepressedBorder textcolor Maize }
				selected_mousedown		{ appearance p_ButtonDepressedBorder textcolor Maize }
				selected_keyfocus		{ appearance p_ButtonDepressedBorder textcolor Maize }
				selected_keyfocus_mouseover	{ appearance p_ButtonDepressedBorder textcolor Maize }

				disabled
				{
					appearance			p_ButtonBorderDisabled
					textcolor		LightGrayBG
					shadowtextcolor		Blank
				}
			}

			LabelDull
			{
				textcolor			DullGreen
				bgcolor				Blank
				selectedtextcolor	Maize
			}

			TextEntry
			{
				appearance		p_InputBorder
				textcolor			White
				bgcolor				Blank
				selectedtextcolor	Black	
				selectedbgcolor		White
				disabled
				{
					appearance		p_InputBorderDisabled
					textcolor			LightGrayBG
					bgcolor				Blank
					selectedtextcolor	Black	
					selectedbgcolor		Blank
				}		
			}
			
			ComboBox
			{
				textcolor	OffWhite
				selectedtextcolor	Maize
				appearance		p_InputBorder
				mouseover	{ textcolor White }
				mousedown	{ textcolor White }
				keyfocus	{ textcolor Maize }
				disabled
				{
					appearance		p_InputBorderDisabled
					textcolor			LightGrayBG
					bgcolor				Blank
					selectedtextcolor	Black	
					selectedbgcolor		Blank
				}		
			}

			CheckButton
			{
				textcolor	OffWhite
				image		Graphics/chkUnselStd
				mouseover
				{
					textcolor Maize
					image	Graphics/chkUnselStd
				}
				mousedown	
				{
					textcolor Maize
					image Graphics/chkSelDown
				}
				selected	
				{
					image Graphics/chkSelStd
				}
				
				keyfocus
				{
					textcolor Maize 
					image	Graphics/chkUnselFocus
				}
				
				keyfocus_mouseover
				{
					textcolor Maize 
					image	Graphics/chkUnselFocus
				}
				
				selected_mouseover	
				{ 
					textcolor Maize 
					image	Graphics/chkSelStd
				}
				
				selected_mousedown
				{
					textcolor Maize
					image	Graphics/chkSelDown
				}
				
				selected_keyfocus
				{
					textcolor Maize
					image	Graphics/chkSelFocus
				}
				
				selected_keyfocus_mouseover
				{
					textcolor Maize  
					image	Graphics/chkSelFocus
				}
				
				disabled
				{
					textcolor		DisabledText2
					image Graphics/chkUnselDis
				}
				selected_disabled
				{
					textcolor		ClayDisabledText
					shadowtextcolor		Blank
					image	Graphics/chkSelDis
				}

			}

			ProgressBar
			{
				textcolor	Maize
				bgcolor		Blank
				appearance		p_InputBorder
			}
			
		}		


		// specific overrides for controls living inside a page inside a wizard
		WizardSubPanelControls
		{
			Button
			{
				textcolor	White
				bgcolor		ClayButtonBG
				appearance		p_ButtonBorder
				
				mousedown
				{
					appearance p_ButtonDepressedBorder
					textcolor	Maize
				}

				keyfocus	
				{ 
					appearance p_ButtonKeyFocusBorder
					textcolor Maize
				}
				
				mouseover	
				{
					textcolor Maize
				}
				
				keyfocus_mouseover		
				{ 
					appearance p_ButtonKeyFocusBorder
					textcolor Maize
				}
				
				defaultbutton
				{ 
					textcolor White
				}
				
				defaultbutton_mouseover		
				{ 
					textcolor Maize
				}

				disabled
				{
					appearance				p_ButtonBorderDisabled
					textcolor			LightGrayBG
					shadowtextcolor		Blank
				}
			}

			ToggleButton
			{
				textcolor	OffWhite
				bgcolor		Blank
				appearance		p_ButtonBorder
				
				mousedown		{ appearance p_ButtonDepressedBorder textcolor Maize }
				mouseover		{ textcolor Maize }
				keyfocus		{ textcolor OffWhite }
				keyfocus_mouseover	{ textcolor Maize }
				
				selected			{ appearance p_ButtonDepressedBorder textcolor Maize }
				selected_mouseover		{ appearance p_ButtonDepressedBorder textcolor Maize }
				selected_mousedown		{ appearance p_ButtonDepressedBorder textcolor Maize }
				selected_keyfocus		{ appearance p_ButtonDepressedBorder textcolor Maize }
				selected_keyfocus_mouseover	{ appearance p_ButtonDepressedBorder textcolor Maize }

				disabled
				{
					appearance			p_ButtonBorderDisabled
					textcolor		DisabledText2
					shadowtextcolor		Blank
				}
			}

			LabelDull
			{
				textcolor			DullGreen
				bgcolor				Blank
				selectedtextcolor	Maize
			}

			TextEntry
			{
				appearance		p_InputBorder
				textcolor			White
				bgcolor				Blank
				selectedtextcolor	Black	
				selectedbgcolor		White
				
				disabled
				{
					appearance		p_InputBorderDisabled
					textcolor			LightGrayBG
					bgcolor				Blank
					selectedtextcolor	Black	
					selectedbgcolor		OffWhite
				}		
			}
			
			ComboBox
			{
				textcolor	OffWhite
				selectedtextcolor	Maize
				appearance		p_InputBorder
				mouseover	{ textcolor White }
				mousedown	{ textcolor White }
				keyfocus	{ textcolor Maize }
				disabled
				{
					appearance		p_InputBorderDisabled
					textcolor			ClayDisabledText
					bgcolor				Blank
					selectedtextcolor	Black	
					selectedbgcolor		Blank
				}		
			}
			CheckButton
			{
				textcolor	OffWhite
				image		Graphics/chkUnselStd
				mouseover
				{
					textcolor Maize
					image	Graphics/chkUnselStd
				}
				mousedown	
				{
					textcolor Maize
					image Graphics/chkSelDown
				}
				selected	
				{
					image Graphics/chkSelStd
				}
				
				keyfocus
				{
					textcolor Maize 
					image	Graphics/chkUnselFocus
				}
				
				keyfocus_mouseover
				{
					textcolor Maize 
					image	Graphics/chkUnselFocus
				}
				
				selected_mouseover	
				{ 
					textcolor Maize 
					image	Graphics/chkSelStd
				}
				
				selected_mousedown
				{
					textcolor Maize
					image	Graphics/chkSelDown
				}
				
				selected_keyfocus
				{
					textcolor Maize
					image	Graphics/chkSelFocus
				}
				
				selected_keyfocus_mouseover
				{
					textcolor Maize  
					image	Graphics/chkSelFocus
				}
				
				disabled
				{
					textcolor		DisabledText1
					image Graphics/chkUnselDis
				}
				selected_disabled
				{
					textcolor		ClayDisabledText
					shadowtextcolor		Blank
					image	Graphics/chkSelDis
				}

			}
			ProgressBar
			{
				textcolor	Maize
				bgcolor		Blank
				appearance		p_InputBorder
			}

			ListPanelInterior
			{
				bgcolor		GrayBG
				appearance		p_ListPanelInteriorBorder
				scrollbar_visible
				{
					appearance	p_ListPanelScrollInteriorBorder
				}
			}
			
			ListPanelSectionHeader
			{
				textcolor	LightGrayBG
				bgcolor		LightGrayBG
			}

			ListPanelSectionCollapser
			{
				textcolor	LightGrayBG
				bgcolor		GrayBG
			}


			RichTextInterior
			{
				appearance		p_RichTextInteriorBorder
				scrollbar_visible
				{
					appearance	p_RichTextScrollInteriorBorder
				}
			}

			SectionedListPanelInterior
			{
				bgcolor		GrayBG
				appearance		p_ListPanelInteriorBorder
				scrollbar_visible
				{
					appearance	p_ListPanelScrollInteriorBorder
				}
			}
			

			HTMLInterior
			{
				bgcolor			Blank
				appearance			p_HTMLInteriorBorder
				scrollbar_visible	{ appearance p_HTMLInteriorBorderScrollbarVisible }
			}
		}

		// controls living in a property page		
		PropertyPageControls
		{
			Button
			{
				textcolor	White
				bgcolor		ClayButtonBG
				appearance		p_ButtonBorder
				
				mousedown
				{
					appearance p_ButtonDepressedBorder
					textcolor	Maize
				}

				keyfocus	
				{ 
					appearance p_ButtonKeyFocusBorder
					textcolor Maize
				}
				mouseover
				{
					textcolor Maize
				}
				
				keyfocus_mouseover		
				{ 
					appearance p_ButtonKeyFocusBorder
					textcolor Maize
				}
				
				defaultbutton
				{ 
					appearance p_ButtonBorderDefault
					textcolor White
				}
				
				defaultbutton_mouseover		
				{ 
					appearance p_ButtonBorderDefault
					textcolor Maize
				}

				disabled
				{
					appearance				p_ButtonBorderDisabled
					textcolor			LightGrayBG
					shadowtextcolor		Blank
				}
			}

			ToggleButton
			{
				textcolor	OffWhite
				bgcolor		Blank
				appearance		p_ButtonBorder
				
				mousedown		{ appearance p_ButtonDepressedBorder textcolor Maize }
				mouseover		{ textcolor Maize }
				keyfocus		{ textcolor OffWhite }
				keyfocus_mouseover	{ textcolor Maize }
				
				selected			{ appearance p_ButtonDepressedBorder textcolor Maize }
				selected_mouseover		{ appearance p_ButtonDepressedBorder textcolor Maize }
				selected_mousedown		{ appearance p_ButtonDepressedBorder textcolor Maize }
				selected_keyfocus		{ appearance p_ButtonDepressedBorder textcolor Maize }
				selected_keyfocus_mouseover	{ appearance p_ButtonDepressedBorder textcolor Maize }

				disabled
				{
					appearance			p_ButtonBorderDisabled
					textcolor		LightGrayBG
					shadowtextcolor		Blank
				}
			}

			LabelDull
			{
				textcolor			DullGreen
				bgcolor				Blank
				selectedtextcolor	Maize
			}

			TextEntry
			{
				appearance		p_InputBorder
				textcolor			White
				bgcolor				Blank
				selectedtextcolor	Black	
				selectedbgcolor		White
				disabled
				{
					appearance		p_InputBorderDisabled
					textcolor			LightGrayBG
					bgcolor				Blank
					selectedtextcolor	Black	
					selectedbgcolor		Blank
				}		
			}
			
			ComboBox
			{
				textcolor	OffWhite
				selectedtextcolor	Maize
				appearance		p_InputBorder
				mouseover	{ textcolor White }
				mousedown	{ textcolor White }
				keyfocus	{ textcolor Maize }
				disabled
				{
					appearance		p_InputBorderDisabled
					textcolor			LightGrayBG
					bgcolor				Blank
					selectedtextcolor	Black	
					selectedbgcolor		Blank
				}		
			}

			CheckButton
			{
				textcolor	OffWhite
				image		Graphics/chkUnselStd
				mouseover
				{
					textcolor Maize
					image	Graphics/chkUnselStd
				}
				mousedown	
				{
					textcolor Maize
					image Graphics/chkSelDown
				}
				selected	
				{
					image Graphics/chkSelStd
				}
				
				keyfocus
				{
					textcolor Maize 
					image	Graphics/chkUnselFocus
				}
				
				keyfocus_mouseover
				{
					textcolor Maize 
					image	Graphics/chkUnselFocus
				}
				
				selected_mouseover	
				{ 
					textcolor Maize 
					image	Graphics/chkSelStd
				}
				
				selected_mousedown
				{
					textcolor Maize
					image	Graphics/chkSelDown
				}
				
				selected_keyfocus
				{
					textcolor Maize
					image	Graphics/chkSelFocus
				}
				
				selected_keyfocus_mouseover
				{
					textcolor Maize  
					image	Graphics/chkSelFocus
				}
				
				disabled
				{
					textcolor		DisabledText2
					image Graphics/chkUnselDis
				}
				selected_disabled
				{
					textcolor		ClayDisabledText
					shadowtextcolor		Blank
					image	Graphics/chkSelDis
				}

			}

			ProgressBar
			{
				textcolor	Maize
				bgcolor		Blank
				appearance		p_InputBorder
			}
			

			ListPanel
			{
				bgcolor		Blank
			}


			ListPanelInterior
			{
				bgcolor			GrayBG
				appearance		p_ListPanelInteriorBorder
				scrollbar_visible
				{
					appearance	p_ListPanelScrollInteriorBorder
				}
			}
			
			ListPanelSectionHeader
			{
				textcolor	Maize
				bgcolor		LightGrayBG
			}

			ListPanelSectionCollapser
			{
				textcolor	LightGrayBG
				bgcolor		GrayBG
			}

			RichTextInterior
			{
				appearance		p_RichTextInteriorBorder
				scrollbar_visible
				{
					appearance	p_RichTextScrollInteriorBorder
				}
			}

			SectionedListPanelInterior
			{
				bgcolor		Blank
			}

			HTML
			{
				bgcolor			Blank
			}

			HTMLInterior
			{
			}
		}
	}

	

	//
	//////////////////////// layout /////////////////////////////
	//
	// describes default layouts for controls that have and control their own children
	// works just like a normal settings .res file, except only positioning attributes are recognized
	LayoutTemplates
	{
		Frame
		{
			frame_menu
			{
				visible	0	// hidden
			}
			
			frame_title
			{
				xpos	6
				ypos	1
				wide	r35
				tall	20
				AutoResize	1
			}
			
			frame_captiongrip
			{
				xpos	4
				ypos	4
				wide	r20
				tall	20
				AutoResize	1
			}
			
			frame_minimize
			{
				xpos	r33
				ypos	3
				wide	16
				tall	16
				PinCorner	1
			}
			
			frame_close
			{
				xpos	r19
				ypos	3
				wide	16
				tall	16
				PinCorner	1
			}

			frame_brGrip
			{
				xpos	r23
				ypos	r23
				wide	20
				tall	20
				PinCorner	3
			}
		}
		
		PropertyDialog
		{
			sheet
			{
				xpos	8
				ypos	26
				wide	r8
				tall	r48
			}
			
			// these buttons are still a bit special - if some of them are hidden, they shuffle
			// across taking the place of other buttons to make sure there aren't gaps
			ApplyButton
			{
				xpos	r84
				ypos	r36
				wide	72
				tall	24
			}
			
			CancelButton
			{
				xpos	r164
				ypos	r36
				wide	72
				tall	24
			}
			
			OKButton
			{
				xpos	r244
				ypos	r36
				wide	72
				tall	24
			}
		}
		
		WizardPanel
		{
			subpanel
			{
				xpos	8
				ypos	28
				wide	r8
				tall	r48
				AutoResize	3
			}
		
			PrevButton
			{
				xpos	r280
				ypos	r36
				wide	84
				tall	24
				PinCorner	3
			}
			NextButton
			{
				xpos	r188
				ypos	r36
				wide	84
				tall	24
				PinCorner	3
			}
			CancelButton
			{
				xpos	r96
				ypos	r36
				wide	84
				tall	24
				PinCorner	3
			}
			FinishButton
			{
				xpos	r96
				ypos	r36
				wide	84
				tall	24
				PinCorner	3
			}
		}
	
	}

	//
	//////////////////////// FONTS /////////////////////////////
	//
	// describes all the fonts
	Fonts
	{
		// fonts are used in order that they are listed
		// fonts listed later in the order will only be used if they fulfill a range not already filled
		// if a font fails to load then the subsequent fonts will replace
		// fonts are used in order that they are listed
		"Default"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"13"
				"weight"	"0"
			}
		}
		"DefaultBold"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"1000"
			}
		}
		"DefaultUnderline"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"13"
				"weight"	"800"
				"underline" "1"
			}
		}
		"DefaultSmall"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"11"
				"weight"	"800"
			}
		}
		ListSmall
		{
			1
			{
				name		Tahoma
				tall		12
				weight		0
			}
		}
		"DefaultVerySmall"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"12"
				"weight"	"800"
			}
		}

		"DefaultLarge"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"18"
				"weight"	"0"
			}
		}
		"UiBold"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"14"
				"weight"	"1000"
			}
		}
		"HeadlineLarge"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"22"
				"weight"	"1000"
				"antialias" "1"
			}
		}
		"UiHeadline"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"13"
				"weight"	"0"
			}
		}
		"MenuLarge"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"16"
				"weight"	"600"
				"antialias" "1"
			}
		}
		// this is the symbol font
		"Marlett"
		{
			"1"
			{
				"name"		"Marlett"
				"tall"		"14"
				"weight"	"0"
				"symbol"	"1"
			}
		}
		MarlettLarge
		{
			"1"
			{
				"name"		"Marlett"
				"tall"		"16"
				"weight"	"0"
				"symbol"	"1"
			}
	
		}
		"DefaultFixed"
		{
			"1"
			{
				"name"		"Lucida Console"
				"tall"		"10"
				"weight"	"0"
			}
		}
		FriendsSmall
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"12"
				"weight"	"800"
			}
		}
		FriendsMedium
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"13"
				"weight"	"800"
			}
		}

		FriendsVerySmall
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"12"
				"weight"	"0"
			}
		}
		FriendsVerySmallUnderline
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"12"
				"weight"	"0"
				"underline"	"1"
			}
		}
		OverlayTaskbarFont
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"1000"
			}
		}
	}
	

	//
	//////////////////// APPEARANCES //////////////////////////////
	//
	// describes all the appearance types
	Appearances
	{
		// render render_bg
		// image fill gradient corner dashedrect
	
		BaseBorder	InsetBorder
		ComboBoxBorder	InsetBorder
		BrowserBorder	NoBorder
		CheckBorder	InsetBorder

		ListPanel.HeaderButtonBorder
		{
			"inset" "2 0 0 0"
		}
		
		PropertySheetBorder
		{
			render
			{
				//"1"		"image( x1, y0, x1 + 10, y0 + 10, Graphics/p_shadow_tr )"		// shadow top right
				//"2"		"image( x1, y0 + 10, x1 + 10, y1 - 3, Graphics/p_shadow_r )"		// shadow right
				//"3"		"image( x1 - 3, y1 - 3, x1 + 10, y1 + 10, Graphics/p_shadow_br )"	// shadow bottom right
				//"4"		"image( x0 + 10, y1, x1 - 3, y1 + 10, Graphics/p_shadow_b )"		// shadow bottom
				//"5"		"image( x0, y1, x0 + 10, y1 + 10, Graphics/p_shadow_bl )"		// shadow bottom left
				//"11"		"corner( x1 - 4, y0, x1, y0 + 4, DarkGreenBG )"		// topright
				//"13"		"corner( x1 - 3, y1 - 3, x1, y1, DarkClayBG )"		// bottomright
				//"14"		"corner( x0, y1 - 3, x0 + 3, y1, ClayBG )"		// bottomleft
			}
		}

		PropertyPageBorder // border and background of an individual 'page' or tab
		{
			render_bg
			{
				"0"		"fill( x0, y0, x1, y1, LightClayBG )"
				//"1"		"gradient( x0, y1 - 40, x1, y1, LightClayBG, ClaySheetBottom)"
			}
		}
		
		WizardExperimentBorder
		{
			render_bg
			{
				"1"		"fill( x0, y0, x1, y1, LightClayBG )"
				//"2"		"gradient( x0, y1 - 40, x1, y1, LightClayBG, ClaySheetBottom)"
				//"3"		"image( x1, y0, x1 + 10, y0 + 10, Graphics/p_shadow_tr )"		// shadow top right
				//"4"		"image( x1, y0 + 10, x1 + 10, y1 - 3, Graphics/p_shadow_r )"	// shadow right
				//"5"		"image( x1 - 3, y1 - 3, x1 + 10, y1 + 10, Graphics/p_shadow_br )"	// shadow bottom right
				//"6"		"image( x0 + 10, y1, x1 - 3, y1 + 10, Graphics/p_shadow_b )"		// shadow bottom
				//"/7"		"image( x0, y1, x0 + 10, y1 + 10, Graphics/p_shadow_bl )"		// shadow bottom left
				//"8"		"corner( x1 - 4, y0, x1, y0 + 4, DarkGreenBG )"		// topright
				//"9"		"corner( x1 - 3, y1 - 3, x1, y1, DarkClayBG )"		// bottomright
				//"10"		"corner( x0, y1 - 3, x0 + 3, y1, ClayBG )"		// bottomleft
			}
		}
		
		PropertySheetBorderTopLeft
		{
		}
		PropertySheetBorderTopRight
		{
		}
		
		ListPanel.HeaderButtonDepressedBorder	ListPanel.HeaderButtonBorder
		ListPanel.HeaderButtonKeyFocusBorder	ListPanel.HeaderButtonBorder
		
		ListPanelDraggerBorder
		{
			render_bg
			{
				//"0"		"fill( x0 + 4, y0, x0 + 5, y1, DarkClayBG )"
				//"1"		"fill( x0 + 5, y0, x0 + 6, y1, ClayDimLightGreen )"
			}
		}

		TitleButtonBorder	RaisedBorder
		TitleButtonDepressedBorder InsetBorder
		TitleButtonDisabledBorder
		{
			"backgroundtype" "0"
		}
		
		MenuBorder
		{
			"corner_rounding" "3"
			
			Right
			{
				"0"
				{
					"color" "LightClayBG"
					"offset" "0 0"
				}
			}

			Left
			{
				"0"
				{
					"color" "LightClayBG"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"0"
				{
					"color" "LightClayBG"
					"offset" "0 0"
				}
			}

			Top
			{
				"0"
				{
					"color" "LightClayBG"
					"offset" "0 0"
				}
			}
		}
		
		FrameBorder
		{
			"corner_rounding" "3"
			render_bg
			{
				"0"		"fill( x0, y0, x1, y1, ClayBG )"
				"1"		"fill( x0, y0, x0+1, y1, LightClayBG )"
				"2"		"fill( x1-1, y0, x1, y1, LightClayBG )"
				"3"		"fill( x0, y1-1, x1, y1, LightClayBG )"
				//"1"		"gradient( x0, y0, x1, y0 + 200, DarkGreenBG, ClayBG)"
				"4"		"fill( x0 + 0, y0 + 0, x1 - 0, y0 + 21, LightGreenBG )" //test
				//"2"		"image( x0 + 8, y0 + 8, x0 + 16, y0 + 16, Graphics/title_tl )"	// topleft
				//"3"		"image( x1 - 16, y0 + 8,  x1 -8, y0 + 16, Graphics/title_tr )"	// topright
			}
		}
		
		InsetBorder
		{
			"inset" "0 0 1 1"
			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		DepressedBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		RaisedBorder
		{
			"inset" "0 0 1 1"
			
			render
			{
				"1"		"fill( x1, y0 + 1, x1 - 1, y1, Border.Dark )"		// right
				"2"		"fill( x0, y0, x0 + 1, y1 - 1, Border.Bright )"		// left
				"3"		"fill( x0, y0, x1, y0 + 1, Border.Bright )"			// top
				"4"		"fill( x0 + 1, y1 - 1, x1, y1, Border.Dark )"		// bottom
			}
		}
		
		RadioButtonKeyFocus		
		{
			"inset"	"0 0 0 0"
			render
			{
				"1"		"dashedrect( x0 + 1, y0 + 1, x1 - 1, y1 - 1, Black )"		
			}
		}
		
		ResizeBorder
		{
			render
			{
				"1"		"image( x0, y0, x1, y1, Graphics/resizer )"
			}
		}

		ResizeMouseoverBorder
		{
			render
			{
				"1"		"image( x0, y0, x1, y1, Graphics/resizer_mouseover )"
			}
		}
		
		ResizeMousedownBorder
		{
			render
			{
				"1"		"image( x0, y0, x1, y1, Graphics/resizer_mousedown )"
			}
		}

		ScrollBarButtonBorder
		{
			"inset" "2 0 0 0"
			render_bg
			{
				"1"		"fill( x0, y0, x1, y1, ClayBG )"
				"2"		"fill( x0 + 4, y0 + 4, x0 + 17, y0 + 16, LightClayBG )"
				"3"		"image( x0 + 3, y0 + 3, x0 + 18, y0 + 17, Graphics/scrEnds )"
			}
		}
		
		ScrollBarButtonMousedownBorder // doesn't work, wah
		{
			"inset" "0 0 0 0"
			render_bg
			{
			//	"1"		"fill( x0, y0, x1, y1, ClayBG )"
			//	"2"		"image( x0 + 4, y0 + 4, x0 + 20, y0 + 20, Graphics/ScrollButton_mousedown )"
			}
		}
		
		ScrollBarSliderBorder
		{
			render_bg
			{
			//	"1"		"fill( x0, y0+1, x1, y1-1, ClayBG )"
				"2"		"fill( x0 + 4, y0 + 1, x0 + 17, y1 - 1, LightClayBG )"
				"3"		"image( x0 + 3, y0, x0 + 7, y0 + 4, Graphics/scrTopLeft )"
				"4"		"image( x0 + 14, y0, x0 + 18, y0 + 4, Graphics/scrTopRight )"
				"5"		"image( x0 + 3, y1 - 4, x0 + 7, y1, Graphics/scrBottomLeft )"
				"6"		"image( x0 + 14, y1 - 4, x0 + 18, y1, Graphics/scrBottomRight )"
				"7"		"image( x0 + 3, y0 + 4, x0 + 7, y1 - 4, Graphics/scrLeft )"
				"8"		"image( x0 + 14, y0 + 4, x0 + 18, y1 - 4, Graphics/scrRight )"
				"9"		"image( x0 + 7, y0, x0 + 14, y0 + 4, Graphics/scrTop )"
				"10"		"image( x0 + 7, y1 - 4, x0 + 14, y1, Graphics/scrBottom )"
			}
		}
		
		Horiz_ScrollBarSliderBorder
		{
			render_bg
			{
				"1"		"fill( x0, y0, x1, y1, ClayBG )"
				"2"		"fill( x0 + 1, y0 + 4, x1 - 1, y0 + 16, LightClayBG )"
				"3"		"image( x0, y0 + 3, x0 + 4, y0 + 7, Graphics/scrTopLeft )"
				"4"		"image( x1 - 4, y0 + 3, x1, y0 + 7, Graphics/scrTopRight )"
				"5"		"image( x0, y0 + 13, x0 + 4, y0 + 17, Graphics/scrBottomLeft )"
				"6"		"image( x1 - 4, y0 + 13, x1, y0 + 17, Graphics/scrBottomRight )"
				"7"		"image( x0, y0 + 7, x0 + 4, y0 + 13, Graphics/scrLeft )"
				"8"		"image( x1 - 4, y0 + 7, x1, y0 + 13, Graphics/scrRight )"
				"9"		"image( x0 + 4, y0 + 3, x1 - 4, y0 + 7, Graphics/scrTop )"
				"10"		"image( x0 + 4, y0 + 13, x1 - 4, y0 + 17, Graphics/scrBottom )"
			}
		}

		ScrollBarSliderMousedownBorder // doesn't work, wah
		{
			render_bg
			{
				"1"		"fill( x0, y0, x1, y1, ClayBG )"
				"2"		"image( x0 + 4, y0, x1 - 4, y0 + 4, Graphics/ScrollSlider_mousedown_t )"
				"3"		"fill( x0 + 4, y0 + 4, x1 - 4, y1 - 4, Black )"
				"4"		"image( x0 + 4, y1 - 4, x1 - 4, y1, Graphics/ScrollSlider_mousedown_b  )"
			}
		}

		ScrollBarSliderMouseoverBorder // doesn't work, wah
		{
			render_bg
			{
				"1"		"fill( x0, y0, x1, y1, ClayBG )"
				"2"		"image( x0 + 4, y0, x1 - 4, y0 + 4, Graphics/ScrollSlider_mouseover_t )"
				"3"		"fill( x0 + 4, y0 + 4, x1 - 4, y1 - 4, White )"
				"4"		"image( x0 + 4, y1 - 4, x1 - 4, y1, Graphics/ScrollSlider_mouseover_b  )"
			}
		}
		
		TabBorder
		{
			inset				"5 0 1 0"
			
			render_bg
			{
				"1"		"fill(  x0 + 3, y0 + 3, x1 + 3, y1 - 1, ClayBG )"			// body
				"2"		"image( x1 + 1, y0 + 2, x1 + 4, y0 + 5, Graphics/tabStdTopRight )"	// topright
				"3"		"image( x0 + 2, y0 + 2, x0 + 5, y0 + 5, Graphics/tabStdTopLeft )"	// topleft
				"4"		"image( x0 + 5, y0 + 2, x1 + 1, y0 + 3, Graphics/tabStdTop )"		// top
				"5"		"image( x0 + 2, y0 + 5, x0 + 3, y1 - 1, Graphics/tabStdLeft )"		// left
				"6"		"image( x1 + 3, y0 + 5, x1 + 4, y1 - 1, Graphics/tabStdRight )"		// right
			}
		}

		TabActiveBorder
		{
			inset				"5 0 1 -2"
			render_bg
			{
				"1"		"image( x1 + 1, y0 + 4, x1 + 4, y0 + 7, Graphics/tabStdTopRight )"	// topright
				"2"		"image( x0 + 2, y0 + 4, x0 + 5, y0 + 7, Graphics/tabStdTopLeft )"	// topleft
				"3"		"image( x0 + 5, y0 + 4, x1 + 1, y0 + 5, Graphics/tabStdTop )"		// top
				"4"		"image( x0 + 2, y0 + 7, x0 + 3, y1 - 1, Graphics/tabStdLeft )"		// left
				"5"		"image( x1 + 3, y0 + 7, x1 + 4, y1 - 1, Graphics/tabStdRight )"		// right
				"6"		"fill(  x0 + 3, y0 + 5, x1 + 3, y1 - 1, LightClayBG )"			// body
			}
		}

		TabKeyfocusBorder
		{
			inset				"5 0 1 -2"
			render_bg
			{
				"1"		"image( x1 + 1, y0 + 4, x1 + 4, y0 + 7, Graphics/tabStdTopRight )"	// topright
				"2"		"image( x0 + 2, y0 + 4, x0 + 5, y0 + 7, Graphics/tabStdTopLeft )"	// topleft
				"3"		"image( x0 + 5, y0 + 4, x1 + 1, y0 + 5, Graphics/tabStdTop )"		// top
				"4"		"image( x0 + 2, y0 + 7, x0 + 3, y1 - 1, Graphics/tabStdLeft )"		// left
				"5"		"image( x1 + 3, y0 + 7, x1 + 4, y1 - 1, Graphics/tabStdRight )"		// right
				"6"		"fill(  x0 + 3, y0 + 5, x1 + 3, y1 - 1, LightClayBG )"			// body
			}
		}

		ToolTipBorder
		{
			"corner_rounding" "2"
			render_bg
			{
				"1"		"fill( x0, y0, x1, y1, DarkClayBG )"
			}
			
			Right
			{
				"0"
				{
					"color" "LightClayBG"
					"offset" "0 0"
				}
			}

			Left
			{
				"0"
				{
					"color" "LightClayBG"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"0"
				{
					"color" "LightClayBG"
					"offset" "0 0"
				}
			}

			Top
			{
				"0"
				{
					"color" "LightClayBG"
					"offset" "0 0"
				}
			}
		}
		
		NewsBorder
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0 + 5, y0, x1 - 5, y1, Graphics/icon_button_news )" }
		}
		NewsBorder_mouseover
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0 + 5, y0, x1 - 5, y1, Graphics/icon_button_news_mouseover )" }
		}
		NewsBorder_mousedown
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0 + 5, y0, x1 - 5, y1, Graphics/icon_button_news_mousedown )" }
		}
		FriendsBorder
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0 + 5, y0, x1 - 5, y1, Graphics/icon_button_friends )" }
		}
		FriendsBorder_mouseover
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0 + 5, y0, x1 - 5, y1, Graphics/icon_button_friends_mouseover )" }
		}
		FriendsBorder_mousedown
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0 + 5, y0, x1 - 5, y1, Graphics/icon_button_friends_mousedown )" }
		}
		ServersBorder
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0 + 5, y0, x1 - 5, y1, Graphics/icon_button_servers )" }
		}
		ServersBorder_mouseover
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0 + 5, y0, x1 - 5, y1, Graphics/icon_button_servers_mouseover )" }
		}
		ServersBorder_mousedown
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0 + 5, y0, x1 - 5, y1, Graphics/icon_button_servers_mousedown )" }
		}
		SettingsBorder
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0 + 5, y0, x1 - 5, y1, Graphics/icon_button_settings )" }
		}
		SettingsBorder_mouseover
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0 + 5, y0, x1 - 5, y1, Graphics/icon_button_settings_mouseover )" }
		}
		SettingsBorder_mousedown
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0 + 5, y0, x1 - 5, y1, Graphics/icon_button_settings_mousedown )" }
		}
		SupportBorder
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0 + 5, y0, x1 - 5, y1, Graphics/icon_button_support )" }
		}
		SupportBorder_mouseover
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0 + 5, y0, x1 - 5, y1, Graphics/icon_button_support_mouseover )" }
		}
		SupportBorder_mousedown
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0 + 5, y0, x1 - 5, y1, Graphics/icon_button_support_mousedown )" }
		}
		MiniMeShrinkBorder
		{
			inset				"0 0 0 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/mini_shrink )" }
		}
		MiniMeShrinkBorder_mouseover
		{
			inset				"0 0 0 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/mini_shrink_mouseover )" }
		}
		MiniMeExpandBorder
		{
			inset				"0 0 0 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/mini_expand )" }
		}
		MiniMeExpandBorder_mouseover
		{
			inset				"0 0 0 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/mini_expand_mouseover )" }
		}
		HomeBorder
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_home )" }
		}
		HomeBorder_over
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_home_over )" }
		}
		HomeBorder_down
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_home_down )" }
		}
		ReloadBorder
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_reload )" }
		}
		ReloadBorder_over
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_reload_over )" }
		}
		ReloadBorder_down
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_reload_down )" }
		}
		BackBorder
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_back )" }
		}
		BackBorder_over
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_back_over )" }
		}
		BackBorder_down
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_back_down )" }
		}
		BackBorder_disabled
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_back_disabled )" }
		}
		ForwardBorder
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_forward )" }
		}
		ForwardBorder_over
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_forward_over )" }
		}
		ForwardBorder_down
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_forward_down )" }
		}
		ForwardBorder_disabled
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_forward_disabled )" }
		}
		
		StopBorder
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_stop )" }
		}
		StopBorder_over
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_stop_over )" }
		}
		StopBorder_down
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_stop_down )" }
		}
		OverlayBorder_on
		{
		inset				"2 0 0 0"
			render_bg
			{
				"0"		"fill( x0 + 2, y0 + 2, x1 - 2, y1 - 2, Black )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnOvrOnRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnOvrOnLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnOvrOnTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnOvrOnBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnOvrOnTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnOvrOnTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnOvrOnBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnOvrOnBottomLeft )"		// bottomleft
			}
		}
		OverlayBorder_off
		{
		inset				"2 0 0 0"
			render_bg
			{
				"0"		"fill( x0 + 2, y0 + 2, x1 - 2, y1 - 2, GrayBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnOvrOffRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnOvrOffLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnOvrOffTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnOvrOffBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnOvrOffTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnOvrOffTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnOvrOffBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnOvrOffBottomLeft )"		// bottomleft
			}
		}
		ButtonBorder
		{
			inset				"4 3 4 4"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, ClayEnabled )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnStdRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnStdLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnStdTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnStdBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnStdTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnStdTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnStdBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnStdBottomLeft )"		// bottomleft
			}
		}

		ButtonKeyFocusBorder
		{
			inset				"4 4 4 4"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, ClayEnabled )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnSelRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnSelLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnSelTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnSelBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnSelTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnSelTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnSelBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnSelBottomLeft )"		// bottomleft
			}
		}

		ButtonBorderDefault
		{
			inset				"4 4 4 4"
			render_bg
			{
				//"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, Maize )"
				"0"		"fill( x0 + 2, y0 + 2, x1 - 2, y1 - 2, ClayEnabled )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnDefRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnDefLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnDefTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnDefBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnDefTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnDefTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnDefBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnDefBottomLeft )"		// bottomleft
			}
		}

		ButtonDepressedBorder
		{
			inset			"6 5 4 4"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, ClayEnabled )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnSelRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnSelLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnSelTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnSelBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnSelTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnSelTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnSelBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnSelBottomLeft )"		// bottomleft
			}
		}

		ButtonBorderDisabled
		{
			inset				"4 4 4 4"
			render_bg
			{
				//"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, ClayEnabled )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnDisRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnDisLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnDisTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnDisBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnDisTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnDisTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnDisBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnDisBottomLeft )"		// bottomleft
			}
		}
		
		p_ButtonBorder
		{
			inset				"4 4 4 4"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, LightClayButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnStdRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnStdLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnStdTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnStdBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnStdTopright )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnStdTopleft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnStdBottomright )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnStdBottomleft )"		// bottomleft
			}
		}

		p_ButtonKeyFocusBorder
		{
			inset				"4 4 4 4"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, LightClayButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnSelRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnSelLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnSelTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnSelBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnSelTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnSelTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnSelBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnSelBottomLeft )"		// bottomleft
			
				// focus edge
				//"13"		"dashedrect( x0 + 5, y0 + 5, x1 - 5, y1 - 5, Black )"		
			
			}
		}

		p_ButtonBorderDefault
		{
			inset				"4 4 4 4"
			render_bg
			{
				//"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, Maize )"
				"0"		"fill( x0 + 2, y0 + 2, x1 - 2, y1 - 2, LightClayButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnDefRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnDefLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnDefTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnDefBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnDefTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnDefTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnDefBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnDefBottomLeft )"		// bottomleft
			}
		}

		p_ButtonDepressedBorder
		{
			inset			"6 5 4 4"

			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, LightClayButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnSelRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnSelLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnSelTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnSelBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnSelTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnSelTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnSelBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnSelBottomLeft )"		// bottomleft
			}
		}

		p_ButtonBorderDisabled
		{
			inset				"4 4 4 4"
			render_bg
			{
				//"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, LightClayButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnDisRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnDisLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnDisTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnDisBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnDisTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnDisTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnDisBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnDisBottomLeft )"		// bottomleft
			}
		}
		
		ListPanelBorder 
		{			
		}

		ListPanelInteriorBorder
		{
			inset				"0 0 0 0"
			render_bg
			{
			    "1"		"fill(  x0, y0, x1, y1, DarkGray )"										// body
			}
		}
		
		ListPanelBorderSimple
		{			
			inset				"0 0 0 0"
			render
			{
				"2"		"image( x0, y0, x1, y0 + 1, Graphics/simTop )"		// top
				"3"		"image( x0, y1 -1, x1, y1, Graphics/simBottom )"		// bottom
			}
		}
		
	
		ListPanelScrollInteriorBorder
		{
			inset				"0 0 0 0"
			render
			{
			//	"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/shadow_r )"		// right
			//	"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/shadow_l )"		// left
			//	"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/shadow_t )"		// top
			//	"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/shadow_b )"		// bottom
			//	"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/shadow_tr )"		// topright
			//	"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/shadow_tl )"		// topleft
			//	"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/shadow_br )"		// bottomright
			//	"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/shadow_bl )"		// bottomleft

			//	"9"		"corner( x1 - 3, y0, x1, y0 + 3, ClayBG )"		// topright
			//	"10"		"corner( x0, y0, x0 + 3, y0 + 3, ClayBG )"		// topleft
			//	"11"		"corner( x1 - 3, y1 - 3, x1, y1, ClayBG )"		// bottomright
			//	"12"		"corner( x0, y1 - 3, x0 + 3, y1, ClayBG )"		// bottomleft
			}
		}

		p_ListPanelInteriorBorder
		{
			inset				"0 0 0 0"
			render_bg
			{
					"1"		"image_tiled( x0, y0, x1, y0 + 5, Graphics/shadowTop )"
					"2"		"fill(   x0, y0 + 5, x1, y1 - 5, GrayBG )"			// body
					"3"		"image_tiled( x0, y1 - 5, x1, y1, Graphics/shadowBottom )"
			}
		}

		p_ListPanelScrollInteriorBorder
		{
			inset				"0 0 0 0"
			render_bg
			{
					"1"		"image_tiled( x0, y0, x1, y0 + 5, Graphics/shadowTop )"
					"2"		"fill( x0, y0 + 5, x1, y1 - 5, GrayBG )"			// body
					"3"		"image_tiled( x0, y1 - 5, x1, y1, Graphics/shadowBottom )"
			}
		}

		p_ListGiftSendInteriorBorder
		{
			inset				"0 0 0 0"
			render_bg
			{
					"1"		"image_tiled( x0, y0, x1, y0 + 5, Graphics/shadowTop )"
					"2"		"fill( x0, y0 + 5, x1, y1, GrayBG )"			// body
					"3"		"image( x1-111, y1 - 132, x1-5, y1-24, Graphics/gift_wizard_friends )"
			}
		}

		p_ListGiftSendScrollInteriorBorder
		{
			inset				"0 0 0 0"
			render_bg
			{
					"1"		"image_tiled( x0, y0, x1, y0 + 5, Graphics/shadowTop )"
					"2"		"fill( x0, y0 + 5, x1, y1, GrayBG )"			// body
					"3"		"image( x1-111, y1 - 132, x1-5, y1-24, Graphics/gift_wizard_friends )"
			}
		}

		p_RichTextInteriorBorder
		{
			inset				"0 0 0 0"
			render
			{

			}
		}

		p_RichTextScrollInteriorBorder
		{
			inset				"0 0 0 0"
			render
			{
			}
		}


		
		HTMLInteriorBorder
		{
			render
			{
				"2"		"image( x1 - 3, y0 - 1, x1, y0 + 2, Graphics/tabStdTopRight )"		// topright
				"3"		"image( x0 - 1 , y0 - 1, x0 + 2, y0 + 2, Graphics/tabStdTopLeft )"		// topleft
				"4"		"image( x1 - 3, y1 - 2, x1, y1 + 1, Graphics/tabStdBottomRight )"	// bottomright
				"5"		"image( x0 - 1, y1 - 2, x0 + 2, y1 + 1, Graphics/tabStdBottomLeft )"	// bottomleft
				"6"		"image( x0 + 2, y0 - 1, x1 - 3, y0, Graphics/tabStdTop )"		// top
				"7"		"image( x0 - 1, y0 + 2, x0, y1 - 2, Graphics/tabStdLeft )"		// left
				"8"		"image( x1 - 1, y0 + 2, x1, y1 - 2, Graphics/tabStdRight )"		// right
				"9"		"image( x0 + 2, y1, x1 - 3, y1 + 1, Graphics/tabStdBottom )"	// bottom
			}
		}
		
		HTMLInteriorBorderScrollbarVisible
		{
			render
			{
				"2"		"image( x1 - 3, y0, x1, y0 + 3, Graphics/tabStdTopRight )"		// topright
				"3"		"image( x0 , y0, x0 + 3, y0 + 3, Graphics/tabStdTopLeft )"		// topleft
				"4"		"image( x1 - 3, y1 - 3, x1, y1, Graphics/tabStdBottomRight )"	// bottomright
				"5"		"image( x0, y1 - 3, x0 + 3, y1, Graphics/tabStdBottomLeft )"	// bottomleft
				"6"		"image( x0 + 3, y0, x1 - 3, y0 + 1, Graphics/tabStdTop )"		// top
				"7"		"image( x0, y0 + 3, x0 + 1, y1 - 3, Graphics/tabStdLeft )"		// left
				"8"		"image( x1 - 1, y0 + 3, x1, y1 - 3, Graphics/tabStdRight )"		// right
				"9"		"image( x0 + 3, y1 - 1, x1 - 3, y1, Graphics/tabStdBottom )"	// bottom
			}
		}
		
		p_HTMLInteriorBorder
		{
			render_bg
			{
			//	"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/shadow_r )"		// right
			//	"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/shadow_l )"		// left
			//	"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/shadow_t )"		// top
			//	"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/shadow_b )"		// bottom
			//	"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/shadow_tr )"		// topright
			//	"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/shadow_tl )"		// topleft
			//	"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/shadow_br )"		// bottomright
			//	"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/shadow_bl )"		// bottomleft
			
			//	"9"		"corner( x1 - 6, y0, x1, y0 + 6, LightClayBG )"		// topright
			//	"10"		"corner( x0, y0, x0 + 6, y0 + 6, LightClayBG )"		// topleft
			//	"11"		"corner( x1 - 6, y1 - 6, x1, y1, LightClayBG )"		// bottomright
			//	"12"		"corner( x0, y1 - 6, x0 + 6, y1, LightClayBG )"		// bottomleft
			}
		}
		
		p_HTMLInteriorBorderScrollbarVisible
		{
			render_bg
			{
			//	"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/shadow_r )"		// right
			//	"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/shadow_l )"		// left
			//	"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/shadow_t )"		// top
			//	"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/shadow_b )"		// bottom
			//	"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/shadow_tr )"		// topright
			//	"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/shadow_tl )"		// topleft
			//	"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/shadow_br )"		// bottomright
			//	"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/shadow_bl )"		// bottomleft

			//	"9"		"corner( x1 - 6, y0, x1, y0 + 6, LightClayBG )"		// topright
			//	"10"		"corner( x0, y0, x0 + 6, y0 + 6, LightClayBG )"		// topleft
			//	"11"		"corner( x1 - 6, y1 - 6, x1, y1, LightClayBG )"		// bottomright
			//	"12"		"corner( x0, y1 - 6, x0 + 6, y1, LightClayBG )"		// bottomleft
			}
		}

		MenuBarBorder
		{
		}
		
		MenuBarButtonBorder
		{
		}
		
		MenuBarButtonDepressedBorder
		{
		}
		
		InputBorder	// for text entry fields and drop-down controls and  boxes
		{
			inset				"4 0 4 0"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, ClayMouseDown )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnStdRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnStdLeft )"			// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnStdTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnStdBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnStdTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnStdTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnStdBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnStdBottomLeft )"		// bottomleft
			}		
		}

		InputBorderWithHeart	// for message text entry field in the gift wizard 
		{
			inset				"4 0 4 0"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, ClayMouseDown )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnStdRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnStdLeft )"			// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnStdTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnStdBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnStdTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnStdTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnStdBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnStdBottomLeft )"		// bottomleft
				"9"		"image( x1 - 134, y0 + 12, x1 - 18, y0 + 117, Graphics/gift_wizard_heart )"	// right
			}		
		}

		p_InputBorder	// for text entry fields and drop-down controls and combo boxes INSIDE WIZARDS OR PROPERTY SHEETS
		{
			inset				"4 0 4 0"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, p_ClayMouseDown )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnStdRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnStdLeft )"			// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnStdTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnStdBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnStdTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnStdTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnStdBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnStdBottomLeft )"		// bottomleft
			}		
		}


		InputBorderDisabled
		{
			inset				"4 0 4 0"
			render_bg // current border is TEMP -- copied from disabled button
			{
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnDisRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnDisLeft )"			// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnDisTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnDisBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnDisTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnDisTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnDisBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnDisBottomLeft )"		// bottomleft
			}	
		}

		p_InputBorderDisabled
		{
			inset				"4 0 4 0"
			render_bg
			{
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnDisRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnDisLeft )"			// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnDisTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnDisBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnDisTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnDisTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnDisBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnDisBottomLeft )"		// bottomleft
			}	
		}

		NoBorder
		{
			"inset" "0 0 0 0"
			render
			{
			}
		}
		
		ChatTitlePanelDefault
		{
			render_bg
			{
			    "1"		"fill(  x0, y0, x1, y1, ClayBG )"			// body
			}
		}
		ChatHistoryPanelDefault
		{
			inset				"0 0 0 0"
			render
			{
				"2"		"image( x1 - 3, y0, x1, y0 + 3, Graphics/tabStdTopRight )"		// topright
				"3"		"image( x0 , y0, x0 + 3, y0 + 3, Graphics/tabStdTopLeft )"		// topleft
				"4"		"image( x1 - 3, y1 - 3, x1, y1, Graphics/tabStdBottomRight )"	// bottomright
				"5"		"image( x0, y1 - 3, x0 + 3, y1, Graphics/tabStdBottomLeft )"	// bottomleft
				"6"		"image( x0 + 3, y0, x1 - 3, y0 + 1, Graphics/tabStdTop )"		// top
				"7"		"image( x0, y0 + 3, x0 + 1, y1 - 3, Graphics/tabStdLeft )"		// left
				"8"		"image( x1 - 1, y0 + 3, x1, y1 - 3, Graphics/tabStdRight )"		// right
				"9"		"image( x0 + 3, y1 - 1, x1 - 3, y1, Graphics/tabStdBottom )"	// bottom
			}
			render_bg
			{
			    "1"		"fill(  x0 + 1, y0 + 1, x1 - 1, y1 - 1, DarkGray )"			// body
			}
		}
		ChatInputBorder	// for text entry fields and drop-down controls and  boxes in Chat
		{
			inset				"4 0 4 0"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, DarkGray )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnStdRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnStdLeft )"			// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnStdTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnStdBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnStdTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnStdTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnStdBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnStdBottomLeft )"		// bottomleft
			}		
		}
		ListPanelSlantBGWithBorder
		{
			inset				"1 1 1 1"
			render
				{
					"2"		"image( x1 - 3, y0, x1, y0 + 3, Graphics/tabSquareTopRight )"		// topright
					"3"		"image( x0 , y0, x0 + 3, y0 + 3, Graphics/tabSquareTopLeft )"		// topleft
					"4"		"image( x1 - 3, y1 - 3, x1, y1, Graphics/tabStdBottomRight )"	// bottomright
					"5"		"image( x0, y1 - 3, x0 + 3, y1, Graphics/tabStdBottomLeft )"	// bottomleft
					"6"		"image( x0 + 3, y0, x1 - 3, y0 + 1, Graphics/tabStdTop )"		// top
					"7"		"image( x0, y0 + 3, x0 + 1, y1 - 3, Graphics/tabStdLeft )"		// left
					"8"		"image( x1 - 1, y0 + 3, x1, y1 - 3, Graphics/tabStdRight )"		// right
					"9"		"image( x0 + 3, y1 - 1, x1 - 3, y1, Graphics/tabStdBottom )"	// bottom
				}
			render_bg
				{
					"1"		"image_tiled( x0 + 1, y0 + 1, x1 - 1, y0 + 90, Graphics/FriendsListSlantBG )"
					"2"		"fill(   x0 + 1, y0 + 90, x1 - 1, y1 - 1, DarkGray )"			// body
				}
		}
		ListPanelSlantBGNoBorder
		{
			inset				"0 0 0 0"
			render_bg
				{
					"1"		"image_tiled( x0, y0, x1, y0 + 90, Graphics/FriendsListSlantBG )"
					"2"		"fill(   x0, y0 + 90, x1, y1, DarkGray )"			// body
				}
		}
		ChatFriendTitlePanelDefault
		{
			render_bg
			{
			    "1"		"image( x0, y0 + 2, x0 + 2, y0 + 50, Graphics/FriendsPanelLeftBG )" // left
			    "2"		"fill(  x0 + 2, y0 + 2, x1 - 2, y0 + 50, Friends.PanelDefault )"			// body
			    "3"		"image( x1 - 2, y0 + 2, x1, y0 + 50, Graphics/FriendsPanelRightBG )" //right
			}
		}
		
		
		VoiceChatOffBG
		{
			inset				"1 1 1 1"
			render
				{
					"2"		"image( x1 - 3, y0, x1, y0 + 3, Graphics/tabStdTopRight )"		// topright
					"3"		"image( x0 , y0, x0 + 3, y0 + 3, Graphics/tabStdTopLeft )"		// topleft
					"4"		"image( x1 - 3, y1 - 3, x1, y1, Graphics/tabStdBottomRight )"	// bottomright
					"5"		"image( x0, y1 - 3, x0 + 3, y1, Graphics/tabStdBottomLeft )"	// bottomleft
					"6"		"image( x0 + 3, y0, x1 - 3, y0 + 1, Graphics/tabStdTop )"		// top
					"7"		"image( x0, y0 + 3, x0 + 1, y1 - 3, Graphics/tabStdLeft )"		// left
					"8"		"image( x1 - 1, y0 + 3, x1, y1 - 3, Graphics/tabStdRight )"		// right
					"9"		"image( x0 + 3, y1 - 1, x1 - 3, y1, Graphics/tabStdBottom )"	// bottom
				}
			render_bg
				{
					"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, ClayBG )"
				}
		}
		VoiceChatOnBG
		{
			inset				"1 1 1 1"
			render
				{
					"2"		"image( x1 - 3, y0, x1, y0 + 3, Graphics/tabStdTopRight )"		// topright
					"3"		"image( x0 , y0, x0 + 3, y0 + 3, Graphics/tabStdTopLeft )"		// topleft
					"4"		"image( x1 - 3, y1 - 3, x1, y1, Graphics/tabStdBottomRight )"	// bottomright
					"5"		"image( x0, y1 - 3, x0 + 3, y1, Graphics/tabStdBottomLeft )"	// bottomleft
					"6"		"image( x0 + 3, y0, x1 - 3, y0 + 1, Graphics/tabStdTop )"		// top
					"7"		"image( x0, y0 + 3, x0 + 1, y1 - 3, Graphics/tabStdLeft )"		// left
					"8"		"image( x1 - 1, y0 + 3, x1, y1 - 3, Graphics/tabStdRight )"		// right
					"9"		"image( x0 + 3, y1 - 1, x1 - 3, y1, Graphics/tabStdBottom )"	// bottom
				}
			render_bg
				{
					"0"		"gradient( x0 + 1, y0 + 1, x1 - 1, y1 - 1, ChatGradientTop, ChatGradientBottom )"
				}
		}
		
		ChatInviteBG
		{
			inset				"1 1 1 1"
			render
				{
					"2"		"image( x1 - 3, y0, x1, y0 + 3, Graphics/tabStdTopRight )"		// topright
					"3"		"image( x0 , y0, x0 + 3, y0 + 3, Graphics/tabStdTopLeft )"		// topleft
					"4"		"image( x1 - 3, y1 - 3, x1, y1, Graphics/tabSquareBottomRight )"	// bottomright
					"5"		"image( x0, y1 - 3, x0 + 3, y1, Graphics/tabSquareBottomLeft )"	// bottomleft
					"6"		"image( x0 + 3, y0, x1 - 3, y0 + 1, Graphics/tabStdTop )"		// top
					"7"		"image( x0, y0 + 3, x0 + 1, y1 - 3, Graphics/tabStdLeft )"		// left
					"8"		"image( x1 - 1, y0 + 3, x1, y1 - 3, Graphics/tabStdRight )"		// right
					"9"		"image( x0 + 3, y1 - 1, x1 - 3, y1, Graphics/tabStdBottom )"	// bottom
				}
			render_bg
				{
					"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, DarkGray )"
				}
		}
		
		FriendPanelDefault
		{
			render_bg
			{
			    "1"		"image( x0, y0 + 2, x0 + 2, y0 + 50, Graphics/FriendsPanelLeftBG )" // left
			    "2"		"fill(  x0 + 2, y0 + 2, x1, y0 + 50, Friends.PanelDefault )"			// body
			}
		}

		FriendPanelMouseOver
		{
			render_bg
			{
			    "1"		"image( x0, y0 + 2, x0 + 2, y0 + 50, Graphics/FriendsPanelLeftBG_Over )" // left
				"2"		"fill(  x0 + 2, y0 + 2, x1, y1, Friends.PanelOver )"			// body
			}
		}

		FriendPanelSelected
		{
			render_bg
			{
			    "1"		"image( x0, y0 + 2, x0 + 2, y0 + 50, Graphics/FriendsPanelLeftBG_Down )" // left
			    "2"		"fill(  x0 + 2, y0 + 2, x1, y1, Friends.PanelSelected )"			// body
			}
		}
		
		FriendPanelAffordanceMouseover
		{
			render_bg
			{
				"1"		"fill(  x0 + 3, y0 + 1, x1 - 2, y1 - 2, DarkGray )"		//body
				"1"		"fill(  x0 + 2, y0 + 2, x1 - 1, y1 - 3, DarkGray )"		//body
			}
		}
		FriendPanelAffordanceMousedown
		{
			render_bg
			{
				"1"		"fill(  x0 + 3, y0 + 2, x1 - 2, y1 - 2, DarkGray )"		//body
				"1"		"fill(  x0 + 2, y0 + 3, x1 - 1, y1 - 3, DarkGray )"		//body
			}
		}
		FriendPanelAffordanceListMouseover
		{
			render_bg
			{
				"1"		"fill(  x0 + 1, y0, x1 - 1, y1, Friends.PanelDefault )"		//body
				"1"		"fill(  x0, y0 + 1, x1, y1 - 1, Friends.PanelDefault )"		//body
			}
		}

	}
}
