#include < amxmodx >
#include < amxmisc >
#include < cstrike >
#include < dhudmessage >
#include < fun >

#define PLUGIN "Reset Score"
#define VERSION "1.3"
#define AUTHOR "OverGame"

#pragma tabsize 0

new const mPrefix [ ] = "\d[ResetScore]\y"
new const cPrefix [ ] = "!g[!tResetScore!t]!y"
new const gSound [ ] = "resetscore/rs.wav"

new gMsg [ 255 ], gName [ 32 ], iExit [ 255 ], iNext [ 255 ], iBack [ 255 ]
new iR, iG, iB, iHud

public plugin_init()
{
    register_plugin ( PLUGIN, VERSION, AUTHOR )
	
	iR = register_cvar ( "resetscore_r", "255" )
	iG = register_cvar ( "resetscore_g", "255" )
	iB = register_cvar ( "resetscore_b", "255" )
	iHud = register_cvar ( "resetscore_hud", "1" )
	
	register_clcmd ( "say /rs", "goto_reset" )
	register_clcmd ( "say_team /rs", "goto_reset" )
	register_clcmd ( "say /resetscore", "goto_reset" )
	register_clcmd ( "say_team /resetscore", "goto_reset" )
	
	register_dictionary ( "resetscore.txt" )
}

public plugin_cfg()
{
	new szCfgDir [ 64 ], szFile [ 192 ]
	
	get_configsdir ( szCfgDir, charsmax ( szCfgDir ) )
	formatex ( szFile, charsmax ( szFile ), "%s/resetscore.cfg", szCfgDir )
	if ( file_exists ( szFile ) )
		server_cmd( "exec %s", szFile )
}

public plugin_precache ( )
{
	precache_sound( gSound )
}

public client_putinserver ( id )
{
	formatex ( iBack, charsmax ( iBack ), "%L", id, "NAME_BACK" )
	formatex ( iNext, charsmax ( iNext ), "%L", id, "NAME_NEXT" )
	formatex ( iExit, charsmax ( iExit ), "%L", id, "NAME_EXIT" )
}

public goto_reset ( id )
{
	static s_MenuItem [ 255 ], Item1 [ 255 ], Item2 [ 255 ]
	
	get_user_name ( id, gName, 31 )
	
	formatex ( s_MenuItem, charsmax ( s_MenuItem ), "%s %L\r %s!\y^n%L^n%L", mPrefix, id, "GOTO_MSG1", gName, id, "GOTO_MSG2", id, "GOTO_MSG3" )
	formatex ( Item1, charsmax ( Item1 ), "\y%L", id, "ITEM_1" )
	formatex ( Item2, charsmax ( Item2 ), "\y%L", id, "ITEM_2" )
	
	new menu = menu_create ( s_MenuItem, "goto_reset_hand" )

	menu_additem ( menu, Item1, "1" )
	menu_additem ( menu, Item2, "2" )
	
	menu_setprop ( menu, MPROP_BACKNAME, iBack )
	menu_setprop ( menu, MPROP_NEXTNAME, iNext )
	menu_setprop ( menu, MPROP_EXITNAME, iExit )

	menu_display ( id, menu, 0 )
	
	return PLUGIN_HANDLED
}

public goto_reset_hand(id, menu, item) 
{
	if(item == MENU_EXIT) 
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}

	new data[6], iName[64], access, callback
	menu_item_getinfo(menu, item, access, data, 5, iName, 63, callback)

	new key = str_to_num(data)
	
	if ( get_pcvar_num ( iHud ) == 1 )
		set_dhudmessage ( get_pcvar_num ( iR ), get_pcvar_num ( iG ), get_pcvar_num ( iB ), 0.1, 0.69, 0, 3.0, 1.0, 0.1, 1.5, false )
	
	switch(key) 
	{
		case 1:
		{
		    if ( get_pcvar_num ( iHud ) == 1 )
				formatex ( gMsg, charsmax(gMsg), "%L", id, "RESET_DONE" )
				
		    if ( get_pcvar_num ( iHud ) != 1 )
				formatex ( gMsg, charsmax(gMsg), "%s %L", cPrefix, id, "RESET_DONE" )
				
			reset_score ( id )
		}
		case 2:
		{
		
		    if ( get_pcvar_num ( iHud ) == 1 )
				formatex ( gMsg, charsmax(gMsg), "%L", id, "RESET_ERROR" )
				
		    if ( get_pcvar_num ( iHud ) != 1 )
				formatex ( gMsg, charsmax(gMsg), "%s %L", cPrefix, id, "RESET_ERROR" )
		}
	}
	
	if ( get_pcvar_num ( iHud ) == 1 )
		show_dhudmessage ( id, gMsg )
		
	if ( get_pcvar_num ( iHud ) != 1 )
		ChatColor ( id, gMsg )
	
	return PLUGIN_HANDLED
}

public reset_score ( id )
{
    set_user_frags ( id, 0 )
	cs_set_user_deaths ( id, 0 )
    set_user_frags ( id, 0 )
	cs_set_user_deaths ( id, 0 )
	
	emit_sound ( id, CHAN_VOICE, gSound, 1.0, 1.0, 0, 150 )
}

stock ChatColor ( const id, const input [ ], any:... )
{
	new count = 1, players [ 32 ]
	static msg [ 188 ]
	vformat ( msg, 187, input, 3 )
	
	replace_all ( msg, 187, "!g", "^4" )
	replace_all ( msg, 187, "!y", "^1" )
	replace_all ( msg, 187, "!t", "^3" )
	
	if ( id ) players [ 0 ] = id; else get_players ( players, count, "ch" )
	{
		for ( new i = 0; i < count; i++ )
		{
			if ( is_user_connected ( players [ i ] ) )
			{
				message_begin ( MSG_ONE_UNRELIABLE, get_user_msgid ( "SayText" ), _, players [ i ] )
				write_byte ( players [ i ] )
				write_string ( msg )
				message_end ( )
			}
		}
	}
}