/* 	
	    ;)
*/
#include <amxmodx>
#include <amxmisc>
#include <colorchat>
#include <fun>
#include <cstrike>
#include <nvault>
#include <sqlx>
//
#define PLUGIN "Army Ranks"
#define VERSION "1.2fix-3"
#define AUTHOR "Arctic"
#pragma tabsize 0
#define ADM_MENU 	ADMIN_IMMUNITY // menu access flag
//
new g_vault;
new Handle:g_SqlTuple;
new g_Error[512]; 
enum _:PlData
{
	gId,gExp,gLevel,gTempKey
};
new UserData[33][PlData];
new gMessage[256];
new g_MsgHud,MaxPlayers,levelUp[33],gSayText;
new bool:restr_blocked;
new const gRankNames[][] = 
{
	"I_0","I_1","I_2","I_3","I_4","I_5","I_6","I_7","I_8","I_9","I_10","I_11","I_12","I_13","I_14",		
	"I_15","I_16","I_17","I_18","I_19","I_20"
};
new const gLevels[] = 
{
	0,15,30,60,100,180,350,750,999,1500,2200,2800,3200,3900,4500,5000,5500,6000,7000,8000
};
new const gNades[][] =
{
	{0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1}
}
new const restrict_bonus[][] =
{
	"35hp",
	"most_wanted",
	"ka_wintershank"
};
new gRestrictMaps,gAdminGMsg,gBonusLevel,gFlash,gSmoke,gHe,gHpbylevel,gApbylevel,
gHideRadar,gArmyChat,gSaveType,gTableName,gHost,gUser,gPassword,gDbName,gSlash,
gTk,gLostXpTk,gLevelUpmsg,gAllChat//,gDeleteNullRow;
//
public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR);
	register_cvar("army_ranks",VERSION, FCVAR_SERVER | FCVAR_SPONLY);
	set_cvar_string("army_ranks",VERSION);
//
	gRestrictMaps 	= register_cvar( "restrict_maps",     	"0");//     .	
	gBonusLevel	= register_cvar( "level_bonus",     	"0");//     .
	gFlash		= register_cvar( "flash_nades",     	"0");//   
	gSmoke		= register_cvar( "smoke_nades",     	"1");//   
	gHe		= register_cvar( "he_nades",     	"1");//   
	gHpbylevel	= register_cvar( "hp_by_level",     	"3");// - ,    ,  = 0 -  
	gApbylevel	= register_cvar( "ap_by_level",     	"5");// - ,    ,  = 0 -  
	gHideRadar	= register_cvar( "hide_radar",     	"1");//    
	gArmyChat	= register_cvar( "army_chat",     	"1");//   ,     ,  .  
	gAdminGMsg	= register_cvar( "admin_color",    	"1");// 1 = . ,0 = , 2 =  
	gSaveType 	= register_cvar( "save_type",     	"0");// 0 - nvault, 1- mysql.
	gSlash 		= register_cvar( "slash_messages",     	"1");//     
	gTk 		= register_cvar( "team_kill_lost_xp",   	"1");//  exp  
	gLostXpTk 	= register_cvar( "lost_xp_val",     	"3");// -  exp  
	gLevelUpmsg	= register_cvar( "level_up_msg",     	"1");//   -  : 1-  (), 2 -  
	gAllChat	= register_cvar( "all_chat",     	"1");// 1 -   (  ), 0-      
//  mysql	
	gHost		= register_cvar( "mysql_host", 		"127.0.0.1"); 	// host
	gUser		= register_cvar( "mysql_user", 		"root");	// username
	gPassword	= register_cvar( "mysql_password", 	"qwerty"); 	// password
	gDbName		= register_cvar( "mysql_db_name", 	"test"); 	// database name
	gTableName	= register_cvar( "mysql_table_name", 	"army_ranks"); 	//   mysql
//
	register_logevent( "EventRoundStart", 2, "1=Round_Start" );
	set_task(1.0,"Info",_,_,_, "b")
	register_event( "DeathMsg","EventDeath","a");
	register_message(get_user_msgid("SayText"), "msg_SayText");
	gSayText = get_user_msgid ("SayText");
//
	g_MsgHud = CreateHudSyncObj();
	MaxPlayers = get_maxplayers();
	register_dictionary("army.txt" );
//
	if(get_pcvar_num(gRestrictMaps))
	{
		new szMapName[64];
		get_mapname(szMapName,63);
		for(new a = 0; a < sizeof restrict_bonus; a++)
		{
			if(equal(szMapName, restrict_bonus[a]))
			{
				restr_blocked = true;
				log_amx("[army ranks] weapon menu is blocked on map [%s].",restrict_bonus[a]);
				break;
			} else {
				restr_blocked = false;
			}	
		}
	}
//
	switch(get_pcvar_num(gSaveType))
	{
		case 0: 
		{
			g_vault = nvault_open("army_ranks");
		}
		case 1: 
		{
			set_task(0.1, "sql_init");
		}
		default: 
		{
			g_vault = nvault_open("army_ranks");
		}
	}
//
	if(get_pcvar_num(gArmyChat))
	{
		register_clcmd("say", "hookSay") 
		register_clcmd("say_team", "hookSayTeam");
	}
	register_clcmd("amx_setlevel","set_level_menu");
}
public plugin_cfg()
{
	new szCfgDir[64], szFile[192];
	get_configsdir(szCfgDir, charsmax(szCfgDir));
	formatex(szFile,charsmax(szFile),"%s/army_ranks.cfg",szCfgDir);
	if(file_exists(szFile))
		server_cmd("exec %s", szFile);
}

public set_level_menu(id)
{
	if(get_user_flags(id) & ADM_MENU)
	{
		UserData[id][gTempKey] = 0;
		new players[32], num;
		get_players(players, num)
		new tempname[32], info[10];
		new players_menu = menu_create("Выберите игрока :", "set_level_hl")
		for(new i = 0; i < num; i++)
		{
			get_user_name(players[i], tempname, 31);
			num_to_str(players[i], info, 9);
			menu_additem(players_menu, tempname, info, 0);
		}
		menu_setprop(players_menu, MPROP_EXIT, MEXIT_ALL);
		menu_display(id, players_menu, 0);
	}
	return PLUGIN_CONTINUE
}
public set_level_hl(id, menu, item)
{
	if(item == MENU_EXIT)
	{
		menu_destroy(menu);
		return PLUGIN_HANDLED;
	}
	new data[6], _access, callback;
	menu_item_getinfo( menu, item, _access, data, charsmax(data), _, _, callback);
	UserData[id][gTempKey] = str_to_num(data);
	set_level_pl(id);
	return PLUGIN_CONTINUE
}
public set_level_pl(id)
{
	static szText[1024];
	formatex(szText,charsmax(szText), "%L", id, "CHOOSE_RANKN");
	new menu = menu_create( szText, "set_level_phl");
//======
	for(new i = 1; i < sizeof(gRankNames); i++)
	{
		new szItem[100],lang[10],num[5];
		format(lang,9,"I_%d",i);
		format(num,4,"%d",i);
		formatex(szItem,charsmax(szItem),"%L",id,lang);
		menu_additem(menu,szItem,num);
	}
//======
	menu_setprop(menu, MPROP_BACKNAME, "Назад ");
	menu_setprop(menu, MPROP_NEXTNAME, "Далее ");
	menu_setprop(menu, MPROP_EXITNAME, "Выход ");
	menu_display( id, menu,0);
	return PLUGIN_CONTINUE;
}
public set_level_phl(id,menu,item)
{
	if(item == MENU_EXIT)
	{
		menu_destroy(menu);
		return PLUGIN_HANDLED;
	}
	new data[6], _access, callback;
	menu_item_getinfo( menu, item, _access, data, charsmax(data), _, _, callback);
	new level = str_to_num(data);
	if(UserData[id][gTempKey] >= 1 && UserData[id][gTempKey] <= 32)
	{
		UserData[UserData[id][gTempKey]][gLevel] = level;
		UserData[UserData[id][gTempKey]][gExp] = gLevels[level-1];
		new szName[2][32];
		get_user_name(id, szName[0], 31);
		get_user_name(UserData[id][gTempKey], szName[1], 31);
		ColorChat(0,NORMAL,"%s give %L level to %s.",szName[0],LANG_PLAYER,gRankNames[level],szName[1])
	} else {
		set_level_menu(id);
	}
	UserData[id][gTempKey] = 0;
	return PLUGIN_HANDLED;
}

//
public sql_init()
{
	new szTableName[64],szHost[64],szUser[64],szPassword[64],szDbName[64],ErrorCode;
	get_pcvar_string(gTableName,szTableName,63);
	get_pcvar_string(gHost,szHost,63);
	get_pcvar_string(gUser,szUser,63);
	get_pcvar_string(gPassword,szPassword,63);
	get_pcvar_string(gDbName,szDbName,63);
	g_SqlTuple = SQL_MakeDbTuple(szHost,szUser,szPassword,szDbName);
	new Handle:SqlConnection = SQL_Connect(g_SqlTuple,ErrorCode,g_Error,511)
	if(SqlConnection == Empty_Handle)
		set_fail_state(g_Error);

	new Handle:Queries = SQL_PrepareQuery(SqlConnection,"CREATE TABLE IF NOT EXISTS `%s`(`id` INT(10) NOT NULL AUTO_INCREMENT,`name` VARCHAR(32) NOT NULL,`exp` INT(10) NOT NULL,`level` INT(10) NOT NULL,PRIMARY KEY (id));", szTableName)
	if(!SQL_Execute(Queries))
	{
		SQL_QueryError(Queries,g_Error,charsmax(g_Error))
		set_fail_state(g_Error);
	}
	SQL_QueryAndIgnore(SqlConnection, "DELETE FROM %s WHERE exp=0 and level=1;",szTableName); // 24.10.12
	SQL_FreeHandle(Queries)
	SQL_FreeHandle(SqlConnection);
}
//
public plugin_end()
{
	switch(get_pcvar_num(gSaveType))
	{
		case 0: 
		{
			nvault_close(g_vault);
		}
		case 1: 
		{
			if(g_SqlTuple != Empty_Handle)
				SQL_FreeHandle(g_SqlTuple);
		}
		default: 
		{
			nvault_close(g_vault);
		}
	}
}
//
public client_putinserver(id) // )
{
	if(get_pcvar_num(gHideRadar))
		client_cmd(id,"hideradar 1");
		
	UserData[id] = UserData[0];
	load_data(id);
}
//
public client_disconnect(id)
{
	save_usr(id);
	UserData[id] = UserData[0];
}
//
public check_level(id)
{
	if(UserData[id][gLevel] <= 0)
		UserData[id][gLevel] = 1;
		
	if(UserData[id][gExp] < 0)
		UserData[id][gExp] = 0;

	while(UserData[id][gExp] >= gLevels[UserData[id][gLevel]]) 
	{
		UserData[id][gLevel]++;
		levelUp[id] = 1;
		switch(get_pcvar_num(gLevelUpmsg))
		{
			case 1: 
			{
				new szName[33];
				get_user_name(id, szName, 32);
				static buffer[192],len;
				len = format(buffer, charsmax(buffer), "^4[^3Army Ranks^4]^1 %L ^4%s^1",LANG_PLAYER,"PLAYER",szName);
				len += format(buffer[len], charsmax(buffer) - len, " %L",LANG_PLAYER,"NEW_LEVEL"); 
				len += format(buffer[len], charsmax(buffer) - len, " ^4%L^1.",LANG_PLAYER,gRankNames[UserData[id][gLevel]]);
				len += format(buffer[len], charsmax(buffer) - len, "%L",LANG_PLAYER,"CONTR");
				ColorChat(0,NORMAL,buffer);
			}
			case 2:
			{
				new szName[33];
				get_user_name(id, szName, 32);
				static buffer[192],len;
				len = format(buffer, charsmax(buffer), "^4[^3Army Ranks^4]^1 %L ^4%s^1",LANG_PLAYER,"PLAYER",szName);
				len += format(buffer[len], charsmax(buffer) - len, " %L",LANG_PLAYER,"NEW_LEVEL"); 
				len += format(buffer[len], charsmax(buffer) - len, " ^4%L^1.",LANG_PLAYER,gRankNames[UserData[id][gLevel]]);
				len += format(buffer[len], charsmax(buffer) - len, "%L",LANG_PLAYER,"CONTR");
				ColorChat(id,NORMAL,buffer);
			}
		}
	}
}
public EventDeath()
{
	new iKiller = read_data(1);
	new iVictim = read_data(2);
	new head = read_data(3);
	if(iKiller != iVictim && is_user_connected(iKiller) && is_user_connected(iVictim) && UserData[iKiller][gLevel] <= 19)
	{
		// if tk?
		if(get_pcvar_num(gTk) && get_user_team(iKiller) == get_user_team(iVictim))
		{
			UserData[iKiller][gExp] -= get_pcvar_num(gLostXpTk);
			return PLUGIN_CONTINUE;
		}
		new weapon = get_user_weapon(iKiller);
		UserData[iKiller][gExp] += 1;
		if(weapon == CSW_KNIFE)
			UserData[iKiller][gExp] += 3;
			
		if(head)
			UserData[iKiller][gExp] += 2;

		if(weapon == CSW_HEGRENADE)
			UserData[iKiller][gExp] += 1;

		check_level(iKiller);
	}
	return PLUGIN_CONTINUE;
}
public EventRoundStart()
{
	for(new id = 1; id <= MaxPlayers; id++)
	{
		if(is_user_alive(id) && is_user_connected(id))
		{
			if(restr_blocked)
				return PLUGIN_CONTINUE;
			
			if(get_pcvar_num(gFlash) && gNades[0][UserData[id][gLevel]])
				give_item(id,"weapon_flashbang");
			
			if(get_pcvar_num(gSmoke) && gNades[1][UserData[id][gLevel]])
				give_item(id,"weapon_smokegrenade");
				
			if(get_pcvar_num(gHe) && gNades[2][UserData[id][gLevel]])
				give_item(id,"weapon_hegrenade");
			
			if(get_pcvar_num(gHpbylevel) != 0)
				set_user_health(id,get_user_health(id)+get_pcvar_num(gHpbylevel)*UserData[id][gLevel]);
				
			if(get_pcvar_num(gApbylevel) != 0)
				set_user_armor(id,get_user_armor(id)+get_pcvar_num(gApbylevel)*UserData[id][gLevel]);	
				
			if(levelUp[id] == 1 && get_pcvar_num(gBonusLevel))
			{
				GetWeapon(id);
				levelUp[id] = 0;
			}
		}
	}
	return PLUGIN_CONTINUE;
}
////////// save
public load_data(id)
{
	new szName[33];
	get_user_name(id,szName,32);
	switch(get_pcvar_num(gSaveType))
	{
		case 0: 
		{
			static data[256], timestamp;
			if(nvault_lookup(g_vault, szName, data, sizeof(data) - 1, timestamp) )
			{
				next_load_data(id, data, sizeof(data) - 1);
				return;
			} else {
				register_player(id,"");
			}
		}
		case 1: 
		{
			new szTableName[32],ErrorCode;
			new Handle:SqlConnection = SQL_Connect(g_SqlTuple,ErrorCode,g_Error,511)
			SQL_QuoteString(SqlConnection, szName, 32, szName);
			get_pcvar_string(gTableName,szTableName,31);
			if(SqlConnection == Empty_Handle)
			{
				log_amx(g_Error);
				return ;
			}
			new Handle:Query = SQL_PrepareQuery(SqlConnection,"SELECT id FROM %s WHERE name = '%s';",szTableName,szName)
			if(!SQL_Execute(Query))
			{
				SQL_QueryError(Query,g_Error,511);
				log_amx(g_Error);
				return ;
			}
			if(SQL_NumResults(Query) > 0 )
			{
				next_load_data(id, "", 0);
			} else {
				register_player(id,"");
			}
			SQL_FreeHandle(Query);
			SQL_FreeHandle(SqlConnection);
		}
		default: 
		{
			static data[256], timestamp;
			if(nvault_lookup(g_vault, szName, data, sizeof(data) - 1, timestamp) )
			{
				next_load_data(id, data, sizeof(data) - 1);
				return;
			} else {
				register_player(id,"");
			}
		}
	}
}
public next_load_data(id,data[],len)
{
	new szName[33];
	get_user_name(id,szName,32);
	switch(get_pcvar_num(gSaveType))
	{
		case 0: 
		{
			replace_all(data,len,"|"," ");
			new exp[5],level[5];
			parse(data,exp,4,level,4);
			UserData[id][gExp]= str_to_num(exp);
			UserData[id][gLevel]= str_to_num(level);
		}
		case 1: 
		{
			new szTableName[32],ErrorCode;
			new Handle:SqlConnection = SQL_Connect(g_SqlTuple,ErrorCode,g_Error,511)
			SQL_QuoteString(SqlConnection, szName, 32, szName);
			get_pcvar_string(gTableName,szTableName,31);
			if(SqlConnection == Empty_Handle)
			{
				log_amx(g_Error);
				return ;
			}
			new Handle:Query = SQL_PrepareQuery(SqlConnection,"SELECT id,exp,level FROM %s WHERE name = '%s';",szTableName,szName)
			if(!SQL_Execute(Query))
			{
				SQL_QueryError(Query,g_Error,511)
				log_amx(g_Error)
			}
			if( SQL_NumResults(Query) > 0)
			{
				UserData[id][gId]= SQL_ReadResult(Query,0); 
				UserData[id][gExp]= SQL_ReadResult(Query,1); 
				UserData[id][gLevel]= SQL_ReadResult(Query,2); 
			}
			SQL_FreeHandle(Query);
			SQL_FreeHandle(SqlConnection);
		}
		default: 
		{
			replace_all(data,len,"|"," ");
			new exp[5],level[5];
			parse(data,exp,4,level,4);
			UserData[id][gExp]= str_to_num(exp);
			UserData[id][gLevel]= str_to_num(level);
		}
	}
// mini-check lvl_up
	if(UserData[id][gLevel] <= 0)
		UserData[id][gLevel] = 1;

	while(UserData[id][gExp] >= gLevels[UserData[id][gLevel]]) 
		UserData[id][gLevel]++;
}
public register_player(id,data[])
{
	new szName[33];
	get_user_name(id,szName,32);
	switch(get_pcvar_num(gSaveType))
	{
		case 0: 
		{
			UserData[id][gExp]= 0
			UserData[id][gLevel]= 1;
		}
		case 1: 
		{
			new szTableName[32],ErrorCode;
			new Handle:SqlConnection = SQL_Connect(g_SqlTuple,ErrorCode,g_Error,511)
			SQL_QuoteString(SqlConnection, szName, 32, szName);
			get_pcvar_string(gTableName,szTableName,31);
			if(SqlConnection == Empty_Handle)
			{
				log_amx(g_Error);
				return ;
			}
			new Handle:Query = SQL_PrepareQuery(SqlConnection,"INSERT INTO %s (`id`,`name`,`exp`,`level`) VALUES (NULL,'%s','0','1');",szTableName,szName);
			if(!SQL_Execute(Query))
			{
				SQL_QueryError(Query,g_Error,511)
				log_amx(g_Error)
			}
			SQL_FreeHandle(Query);
			SQL_FreeHandle(SqlConnection);
			UserData[id][gExp] = 0;
			UserData[id][gLevel] = 1;
		}
		default: 
		{
			UserData[id][gExp]= 0
			UserData[id][gLevel]= 1;
		}
	}
}
public save_usr(id)
{
	new szName[33];
	get_user_name(id,szName,32);
	switch(get_pcvar_num(gSaveType))
	{
		case 0: 
		{
			static data[256];
			formatex(data, 255, "|%i|%i|", UserData[id][gExp],UserData[id][gLevel]);
			nvault_set(g_vault, szName, data);
		}
		case 1: 
		{
			new saveq[256],szTableName[32];
			get_pcvar_string(gTableName,szTableName,31);
			format(saveq,255,"UPDATE `%s` SET `exp`='%d',`level`='%d' WHERE `id`='%d';", szTableName,UserData[id][gExp],UserData[id][gLevel],UserData[id][gId])
			SQL_ThreadQuery(g_SqlTuple,"QueryHandler",saveq);
		}
		default: 
		{
			static data[256];
			formatex(data, 255, "|%i|%i|", UserData[id][gExp],UserData[id][gLevel]);
			nvault_set(g_vault, szName, data);
		}
	}
}
///////// chat event
public hookSay(id)
{
	if(is_user_hltv(id) || is_user_bot(id) || !is_user_connected(id))
		return PLUGIN_CONTINUE;

	new message[192],Len;
	read_args(message, 191);
	remove_quotes(message);
	if(is_admin_msg(message))
		return PLUGIN_CONTINUE;
	
	if(is_empty_message(message))
	{
		ColorChat(id,NORMAL,"^4[^3Army Ranks^4]^1 %L",LANG_PLAYER,"EMPTY_MSG")
		return PLUGIN_HANDLED
	}
	if(get_pcvar_num(gSlash))
	{
		if(is_has_slash(message))
			return PLUGIN_HANDLED_MAIN
	}
	new szName[32];
	get_user_name(id,szName,31);
	if(is_user_admin(id))
	{
		Len = format(gMessage[Len], charsmax(gMessage) - 1, "^4[^3%L^4] ",LANG_PLAYER,gRankNames[UserData[id][gLevel]]);
		switch(get_pcvar_num(gAdminGMsg))
		{
			case 1:
			{
				Len += format(gMessage[Len], charsmax(gMessage) - 1, "^3%s^4 : ",szName);
				Len += format(gMessage[Len], charsmax(gMessage) - 1, "%s",message);
			}
			case 2:
			{
				Len += format(gMessage[Len], charsmax(gMessage) - 1, "^3%s^4 : ",szName);
				Len += format(gMessage[Len], charsmax(gMessage) - 1, "^3%s",message);
			}
			default:
			{
				Len += format(gMessage[Len], charsmax(gMessage) - 1, "^3%s^4 : ",szName);
				Len += format(gMessage[Len], charsmax(gMessage) - 1, "^1%s",message);
			}
		}
		Chat(id,0,get_pcvar_num(gAllChat));
	}
	else 
	{
		Len = format(gMessage[Len], charsmax(gMessage) - 1, "^4[^3%L^4] ",LANG_PLAYER,gRankNames[UserData[id][gLevel]]);
		Len += format(gMessage[Len], charsmax(gMessage) - 1, "^3%s^4 : ",szName);
		Len += format(gMessage[Len], charsmax(gMessage) - 1, "^1%s",message);
		Chat(id,0,get_pcvar_num(gAllChat));
	}
	return PLUGIN_HANDLED_MAIN
}
public hookSayTeam(id)
{
	if(is_user_hltv(id) || is_user_bot(id) || !is_user_connected(id))
		return PLUGIN_CONTINUE;

	new message[192],Len;
	read_args(message, 191);
	remove_quotes(message);
	if(is_admin_msg(message))
		return PLUGIN_CONTINUE;
		
	if(is_empty_message(message))
	{
		ColorChat(id,NORMAL,"^4[^3Army Ranks^4]^1 %L",LANG_PLAYER,"EMPTY_MSG");
		return PLUGIN_HANDLED
	}
	if(get_pcvar_num(gSlash))
	{
		if(is_has_slash(message))
			return PLUGIN_HANDLED_MAIN
	}
	new szName[32];
	get_user_name(id,szName,31);
	if(is_user_admin(id))
	{
		Len = format(gMessage[Len], charsmax(gMessage) - 1, "^3%L^1 ^4[^3%L^4] ^3%s^4 : ",LANG_PLAYER,"SEND_TEAM",LANG_PLAYER,gRankNames[UserData[id][gLevel]],szName);		
		switch(get_pcvar_num(gAdminGMsg))
		{
			case 1:
			{
				Len += format(gMessage[Len], charsmax(gMessage) - 1, "%s",message);
			}
			case 2:
			{
				Len += format(gMessage[Len], charsmax(gMessage) - 1, "^3%s",message);
			}
			default:
			{
				Len += format(gMessage[Len], charsmax(gMessage) - 1, "^1%s",message);
			}
		}
		Chat(id,1,get_pcvar_num(gAllChat));
	}
	else 
	{
		Len = format(gMessage[Len], charsmax(gMessage) - 1, "^3%L^1 ^4[^3%L^4] ",LANG_PLAYER,"SEND_TEAM",LANG_PLAYER,gRankNames[UserData[id][gLevel]]);
		Len += format(gMessage[Len], charsmax(gMessage) - 1, "^3%s^4 : ",szName);
		Len += format(gMessage[Len], charsmax(gMessage) - 1, "^1%s",message);
		Chat(id,1,get_pcvar_num(gAllChat));
	}
	return PLUGIN_HANDLED_MAIN
}
stock is_admin_msg(const Message[])
{
	if(Message[0] == '@')
		return true;
		
	return false;
}
stock is_empty_message(const Message[])
{
	if(equal(Message, "") || !strlen(Message))
		return true;
		
	return false;
}
stock Chat(id,team,chat_type)
{
	if(team)
	{
		if(chat_type)
		{
			for(new i = 1; i <= MaxPlayers; i++)
			{
				if(!is_user_connected(i))
					continue
			
				if(get_user_team(id) == get_user_team(i))
					send_message(gMessage, id, i);
			}
		} else {
			if(is_user_alive(id))
			{
				for(new i = 1; i <= MaxPlayers; i++)
				{
					if(!is_user_connected(i) || !is_user_alive(i))
						continue
				
					if(get_user_team(id) == get_user_team(i))
						send_message(gMessage, id, i);
				}
			} else if(!is_user_alive(id)){
				for(new i = 1; i <= MaxPlayers; i++)
				{
					if(!is_user_connected(i) || is_user_alive(i))
						continue
				
					if(get_user_team(id) == get_user_team(i))
						send_message(gMessage, id, i);
				}
			}
		}
	} else{
		if(chat_type)
		{
			for(new i = 1; i <= MaxPlayers; i++)
			{
				if(!is_user_connected(i))
					continue
			
				send_message(gMessage, id, i);
			}
		} else {
			if(is_user_alive(id))
			{
				for(new i = 1; i <= MaxPlayers; i++)
				{
					if(!is_user_connected(i) || !is_user_alive(i))
						continue
				
					send_message(gMessage, id, i);
				}
			} else if(!is_user_alive(id)){
				for(new i = 1; i <= MaxPlayers; i++)
				{
					if(!is_user_connected(i) || is_user_alive(i))
						continue
				
					send_message(gMessage, id, i);
				}
			}
		}
	}
}
stock send_message(const message[], const id, const i)
{
	message_begin(MSG_ONE, gSayText, {0, 0, 0}, i)
	write_byte(id)
	write_string(message)
	message_end()
}
stock is_has_slash(const Message[])
{
	if(Message[0] == '/')
		return true;
		
	return false;
}

public client_infochanged(id)
{
	new newname[32],oldname[32]
	get_user_info(id, "name", newname,31)
	get_user_name(id,oldname,31)
	if(!is_user_connected(id) || is_user_bot(id)) 
		return PLUGIN_CONTINUE
		
	if(!equali(newname, oldname))
	{
		set_user_info(id,"name",oldname);
		log_amx("namechange BLOCKED.");
		return PLUGIN_HANDLED
	}
	return PLUGIN_CONTINUE
}
public msg_SayText()
{
	new arg[32]
	get_msg_arg_string(2, arg, 31)
	if(containi(arg,"name")!=-1)
		return PLUGIN_HANDLED

	return PLUGIN_CONTINUE
}
/////////// natives
public plugin_natives()
{
	register_native("get_user_exp", "native_get_user_exp", 1);
	register_native("get_user_lvl", "native_get_user_lvl", 1);
	register_native("set_user_exp", "native_set_user_exp", 1);
	register_native("set_user_lvl", "native_set_user_lvl", 1);
	register_native("get_user_rankname", "native_get_user_rankname", 1);
}
public native_set_user_exp(id,num)
{
	UserData[id][gExp] = num;
}
public native_set_user_lvl(id,num)
{
	UserData[id][gLevel] = num;
}
public native_get_user_exp(id)
{
	return UserData[id][gExp];
}
public native_get_user_lvl(id)
{
	return UserData[id][gLevel];
}
public native_get_user_rankname(id)
{
	static szRankName[64];
	format(szRankName, charsmax(szRankName), "%L",LANG_PLAYER,gRankNames[UserData[id][gLevel]]);
	return szRankName;
}
//////// informer
public Info()
{
	for(new id = 1; id <= MaxPlayers; id++)
	{
		if(!is_user_bot(id) && is_user_connected(id))
		{
			if(get_pcvar_num(gHideRadar))
				set_hudmessage(100, 100, 100, 0.01, 0.01, 0, 1.0, 1.0, _, _, -1);
			else
				set_hudmessage(100, 100, 100, 0.01, 0.13, 0, 1.0, 1.0, _, _, -1)
			
			static buffer[192], len;
			len = format(buffer, charsmax(buffer), "%L",LANG_PLAYER,"ZVANIE");
			len += format(buffer[len], charsmax(buffer) - len, " %L",LANG_PLAYER,gRankNames[UserData[id][gLevel]]);
			if(UserData[id][gLevel] <= 19)
			{
				len += format(buffer[len], charsmax(buffer) - len, "^n%L",LANG_PLAYER,"PL_XP",UserData[id][gExp],gLevels[UserData[id][gLevel]]);
			} else {
				len += format(buffer[len], charsmax(buffer) - len, "^n%L",LANG_PLAYER,"PL_MAX");
			}
			ShowSyncHudMsg(id, g_MsgHud, "%s", buffer);
		}
	}
	return PLUGIN_CONTINUE
}
/////// weap menu per lvl
public GetWeapon(id)
{
	new szText[700 char];
	formatex( szText, charsmax( szText ), "%L", id, "GW_TITLE");
	new menu = menu_create( szText, "gw_menu" );
//
	formatex( szText, charsmax( szText ), "awp");
	menu_additem( menu, szText, "1", 0 );
//
	formatex( szText, charsmax( szText ), "ak-47");
	menu_additem( menu, szText, "2", 0 );
//
	formatex( szText, charsmax( szText ), "m4a1");
	menu_additem( menu, szText, "3", 0 );
//
	formatex( szText, charsmax( szText ), "famas");
	menu_additem( menu, szText, "4", 0 );
//
	menu_setprop( menu, MPROP_EXIT, MEXIT_ALL );
	menu_display( id, menu,0);
	return PLUGIN_CONTINUE;
}
public gw_menu(id,menu,item)
{
	if( item == MENU_EXIT )
	{
		return PLUGIN_HANDLED;
	}
	
	new data[ 6 ], iName[ 64 ], access, callback;
	menu_item_getinfo( menu, item, access, data, charsmax( data ), iName, charsmax( iName ), callback );
	new key = str_to_num( data );
	switch( key )
	{
		case 1:
		{
			give_item(id,"weapon_awp");
			cs_set_user_bpammo( id, CSW_AWP, 100);
		}
		case 2:
		{
			give_item(id,"weapon_ak47");
			cs_set_user_bpammo( id, CSW_AK47, 200);
		}
		case 3:
		{
			give_item(id,"weapon_m4a1");
			cs_set_user_bpammo( id, CSW_M4A1, 200);
		}
		case 4:
		{
			give_item(id,"weapon_famas");
			cs_set_user_bpammo( id, CSW_FAMAS, 200);
		}
	}
	
	return PLUGIN_HANDLED;
}
public QueryHandler(FailState,Handle:Query,Error[],Errcode,Data[],DataSize)
{
	switch(FailState)
	{
		case -2: log_amx("[Army Ranks] Failed to connect (%d): %s", Errcode, Error);
		case -1: log_amx("[Army Ranks] (%d): %s", Errcode, Error);
	}
	return PLUGIN_HANDLED
}
